<?php

use Webuccino\Install\Core\App;
use Webuccino\Install\Core\Session;
use Webuccino\Install\Core\Database;

$db = App::resolve(Database::class);

if (isset($_POST["confirm_smtp_no"])) {
    Session::put('smtp-connection-success', true);
    return;
}

$attributes = [
    'smtp'       => $_POST['smtp_host'],
    'port'       => $_POST['smtp_port'],
    'username'   => $_POST['smtp_username'],
    'Password'   => encrypt_native($_POST['smtp_password']),
    'encryption' => $_POST['smtp_encryption'],
    'auth_mode'  => $_POST['smtp_auth_mode'],
    'is_default' => 1
];

$db->update('mail', [], ['is_default' => 0]);

$db->create('mail', $attributes);

Session::put('smtp-connection-success', true);

writeLog("Connection to SMTP is successful");

echo json_encode([
    'msg' => "Connection to SMTP is successful"
]);
