<?php

namespace Webuccino\Install\Http\Forms;

use Webuccino\Install\Core\ValidationException;
use Webuccino\Install\Core\Validator;

class SMTPForm
{
    protected $errors = [];

    public $attributes;

    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;

        if (!Validator::string($attributes['smtp'])) {
            $this->errors['smtp'] = 'Field is required';
        }

        if (!Validator::string($attributes['port'])) {
            $this->errors['port'] = 'Field is required';
        }

        if (!Validator::string($attributes['username'])) {
            $this->errors['username'] = 'Field is required';
        }

        if (!Validator::string($attributes['Password'])) {
            $this->errors['Password'] = 'Field is required';
        }

        if (!Validator::string($attributes['encryption'])) {
            $this->errors['encryption'] = 'Field is required';
        }

        if (!Validator::string($attributes['auth_mode'])) {
            $this->errors['auth_mode'] = 'Field is required';
        }
    }

    public static function validate($attributes)
    {
        $instance = new static($attributes);

        return $instance->failed() ? true : false;
    }

    public function throw()
    {
        ValidationException::throw($this->errors(), $this->attributes);
    }

    public function failed()
    {
        return count($this->errors);
    }

    public function errors()
    {
        return $this->errors;
    }

    public function error($field, $message)
    {
        $this->errors[$field] = $message;

        return $this;
    }
}
