<?php

namespace Webuccino\Install\Core;

use Webuccino\Install\Core\App;
use Webuccino\Install\Core\Database;

class Validator
{
    public static function string($value, $min = 1, $max = INF)
    {
        $value = trim($value);

        return strlen($value) >= $min && strlen($value) <= $max;
    }

    public static function max($value, $max = 255)
    {
        $value = trim($value);

        return strlen($value) <= $max;
    }


    public static function min($value, $min = 1)
    {
        $value = trim($value);

        return strlen($value) >= $min;
    }

    public static function email($value)
    {
        return filter_var($value, FILTER_VALIDATE_EMAIL);
    }

    public static function not_exists($value, $table, $column)
    {
        $db = App::resolve(Database::class);

        return !$db->checkExist($table, [[$column, $value]]);
    }

    public static function complex($value, $min = 3, $max = 16)
    {
        $number = preg_match('@[0-9]@', $value);
        $uppercase = preg_match('@[A-Z]@', $value);
        $lowercase = preg_match('@[a-z]@', $value);

        if (strlen($value) < 3 || strlen($value) > 16 || !$number || !$uppercase || !$lowercase) {
            return false;
        } else {
            return true;
        }
    }

    public static function equal($value, $other)
    {
        return $value === $other;
    }

    public static function numeric($value)
    {
        $number = preg_match('@[0-9]@', (int)$value);

        if ($number) return true;
        else return false;
    }

    public static function checked($value)
    {
        return isset($value) && $value == 1;
    }
}
