<?php

namespace Webuccino\Install\Core;

class Seeder
{
    public $seeders;

    public function __construct()
    {
        $this->seeders = [
            'Webuccino\Install\seeder\InstalledVersionsSeeder',
            'Webuccino\Install\seeder\ModulesSeeder',
            'Webuccino\Install\seeder\CategoriesSeeder',
            'Webuccino\Install\seeder\OrganizationSeeder',
            'Webuccino\Install\seeder\SettingsSeeder',
            'Webuccino\Install\seeder\EmbeddingPreferenceSeeder'
        ];

        $testing_data = config_native("srm_config.dashboard.demo.testing_data",true) ?? true;

        if ((!is_docker() && $testing_data) ||
            (!is_null(getenv('ADD_TESTING_DATA')) && getenv('ADD_TESTING_DATA') == 'true')
        ) {
            $this->seeders[] = 'Webuccino\Install\seeder\NorthWindSeeder';
        }

    }

    public function runSeeders()
    {

        foreach ($this->seeders as $seeder) {
            try {
                (new $seeder())->run();
                writeImportLog(basename(str_replace("\\", "/", $seeder)) . " class seeded successfully.");
            } catch (\Exception $e) {
                writeImportLog("Seeding error: " . $e->getMessage() . $e->getTraceAsString());
            }

        }

    }

}
