<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 */
defined('DIRECTACESS') or die("Error 301: Access denied!");
require_once "request.php";
require_once "lib.php";
require_once 'checkSession.php';

if (sessionBe4Step4() === false) {
    header("location: $url?id=1");
    exit();
}
$isParentOrIntermediate   = in_array( $_SESSION[Session_report_Settings_key]["report_relationship"],["parent","intermediate"]);

$parameters = isset($_SESSION[Session_report_Parameters_Mapping]) ? $_SESSION[Session_report_Parameters_Mapping] : array();
// var_dump($parameters);
$_SESSION[Session_wizard_key]['page_key'] = "step_4";
require_once 'activePages.php';

if (isset($_SESSION[Session_report_Settings_key]["datasource"])) {
    $datasource = $_SESSION[Session_report_Settings_key]["datasource"];
} else {
    header("location: $url?id=0");
}

$allFields = array();

// set data from session to fields
if ($datasource === "table") {
    if (isset($_SESSION[Session_report_Settings_key]["table"])) {
        $table = $_SESSION[Session_report_Settings_key]["table"];
    } else {
        header("location: $url?id=1");
    }

    foreach ($table as $key => $val) {
        $val = clean_input($val);
        //populating keys
        $result = $dbHandler->query("SHOW COLUMNS FROM `$val`", "NUM", array(), $srm_dashboard);

        foreach ($result as $key => $row) {

            if (count($table) === 1) {
                $allFields[] = $row[0];
            } else {
                $allFields[] = $val . "." . $row[0];
            }

        }

    }

} else {

    if (isset($_SESSION[Session_report_Settings_key]["sql"])) {
        $sql = $_SESSION[Session_report_Settings_key]["sql"];
    } else {
        header("location: $url?id=1");
    }

    $sql = make_valid($sql);
    $sql = $sql . ' LIMIT 1';

    $result = $dbHandler->query($sql, 'ASSOC', array(), $srm_dashboard);
    $rows   = $dbHandler->get_num_rows();

    if ($rows !== 0) {

        foreach ($result[0] as $key => $val) {
            $allFields[] = $key;
        }

    } else {
        $error .= "<br>*Records = 0, please click back and enter another query";
    }
    $_SESSION[Session_report_Settings_key]["fields"]  = $allFields;
    $_SESSION[Session_report_Settings_key]["fields2"] = $allFields;
}

// ------------------------------------------------------------------------------------
// ------------------------------------ Statistical -----------------------------------
$functions      = array("sum", "avg", "min", "max", "count");
$selectedFields = isset($_SESSION[Session_report_Settings_key]["fields"]) ? $_SESSION[Session_report_Settings_key]["fields"] : array();

// ------------------------------------------------------------------------------------
// ------------------------------------ Label -----------------------------------------

$labels = isset($_SESSION[Session_report_Settings_key]["labels"]) ? $_SESSION[Session_report_Settings_key]["labels"] : array();
$tables = isset($_SESSION[Session_report_Settings_key]["table"]) ? $_SESSION[Session_report_Settings_key]["table"] : array();
if (empty($labels) || count($labels) < 1) {
    $labels = array();

    foreach ($selectedFields as $field) {
        $chunks         = explode('.', $field);
        $labels[$field] = (count($tables) === 1) ? $field : (isset($chunks[1]) ? $chunks[1] : $chunks[0]);
    }

    $_SESSION[Session_report_Settings_key]["labels"] = $labels;
} else {
    $temp = array();

    foreach ($selectedFields as $field) {

        if (array_key_exists($field, $labels)) {
            $temp[$field] = $labels[$field];
        } else {
            $chunks       = explode('.', $field);
            $temp[$field] = (count($tables) === 1) ? $field : (isset($chunks[1]) ? $chunks[1] : $chunks[0]);
        }

    }

    $labels                                          = $temp;
    $_SESSION[Session_report_Settings_key]["labels"] = $labels;
}

?>
<div id="tabs" style="min-height: 350px;" class="container col-xs-12">
  <!-- -->
  <!-- Nav tabs nav nav-tabs -->
  <ul class="" style="font-size: 12px;">

    <?php

    if ($datasource === "table") {?>
    <li class="active"><a id="columns-nav" href="#columns" data-toggle="tab"><span
          class="glyphicon glyphicon-th"></span> Columns</a></li>
    <?php }

    if ($isParentOrIntermediate) {
        ?>
      <li><a id="parameter-mapping-nav" href="#parameter-mapping" data-toggle="tab"><span
      class="glyphicon glyphicon-cog"></span> Parameter Mapping</a></li>

    <?php }

    ?>
    <li><a id="labels-nav" href="#labels" data-toggle="tab"><span class="glyphicon glyphicon-pencil"></span> Labels</a>
    </li>
    <?php
        //disable Aggregation Functions

    if ($datasource === "table" && false) {?>
    <li><a id="statistical-nav" href="#statistical" data-toggle="tab"><span class="glyphicon glyphicon-stats"></span>
        Aggregation Functions</a></li>
    <?php }

    ?>
  </ul>
  <!-- Tab panes -->
  <div class="tab-content">

    <?php

    if ($datasource === "table") {?>
    <div class="tab-pane active" id="columns">
      <form name="form1" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" onsubmit="return false;"
      style="margin-bottom: 0px;">

        <div class="row">
          <div class="col-xs-1"></div>
          <div id="error-container" class="col-xs-11">
          </div>
        </div><!-- .row (error) -->

        <div class="row">
          <div class="form-group col-xs-5" style="margin: 0px; padding: 0px 5px 0px 0px;">
            <label for="allFields">Available Fields</label>
            <div class="left-inner-addon-cells">
              <i class="glyphicon glyphicon-pushpin"></i>
              <select size="5" name="allFields" id="allFields" class="form-control" style="height: 200px;" multiple>
                <?php

                        foreach ($allFields as $val) {

                            if (isset($_SESSION[Session_report_Settings_key]["fields"])) {

                                if (!in_array($val, $_SESSION[Session_report_Settings_key]["fields"])) {
                                    echo "<option value='$val'>$val</option>";
                                }

                            } else {
                                echo "<option value='$val'>$val</option>";
                            }

                        }

        ?>
              </select>
            </div>
          </div>
          <div class="col-xs-1" style="padding-top: 15px;">
            <br />
            <div class="row" style="margin-top: 33px;">
              <button name="add" id="add" style="outline: none;padding: 2px;font-size: smaller;" class="btn btn-default btn-block btn-xs">&#9654;</button>
            </div>

            <div class="row" style="margin-top: 5px;">
              <button name="remove" id="remove" style="outline: none;padding: 2px;font-size: smaller;" class="btn btn-default btn-block btn-xs">&#9664;</button>
            </div>

            <div class="row" style="margin-top: 5px;">
              <button name="addAll" id="addAll" style="letter-spacing: -5px;outline: none;padding: 2px;font-size: smaller;" class="btn btn-default btn-block btn-xs">&#9654;&#9654;</button>
            </div>

            <div class="row" style="margin-top: 5px;">
              <button name="removeAll" id="removeAll" style="letter-spacing: -5px;outline: none;padding: 2px;font-size: smaller;" class="btn btn-default btn-block btn-xs">&#9664;&#9664;</button>
            </div>
          </div>
          <div class="form-group col-xs-5" style="margin: 0px; padding: 0px 0px 0px 5px;">

            <label for="selectedFields">Selected Fields</label>
            <div class="left-inner-addon">
              <i class="glyphicon glyphicon-pushpin"></i>
              <select size="2" name="selectedFields" id="selectedFields" class="form-control" style="height: 200px;"
                multiple>
                <?php

            if (isset($_SESSION[Session_report_Settings_key]["fields"])) {

                foreach ($_SESSION[Session_report_Settings_key]["fields"] as $val) {

                    if (in_array($val, $allFields)) {
                        echo "<option value='$val'>$val</option>";
                    }

                }

            }

        ?>
              </select>
            </div>
          </div>
          <div class="col-xs-1" style="padding-top: 40px;">
            <br>
            <div class="row" style="margin-top: 5px;">
              <button name="moveUp" id="moveUp" class="btn btn-default btn-block btn-xs"
                style="outline: none;margin-left: 10px;">&#9650;</button>
            </div>

            <div class="row" style="margin-top: 5px;">
              <button name="moveDown" id="moveDown" class="btn btn-default btn-block btn-xs"
                style="outline: none;margin-left: 10px;">&#9660;</button>
            </div>

          </div>
        </div> <!-- .row (selectColumns) -->

        <div class="row" style="position: relative;top: -222px; left: 523px;width: 20px;">
          <a href="" id="sfHelp" onClick="return false;">
            <img src="includes/images/help.png" width="15" height="15" border="0">
          </a>
        </div><!-- help -->

        <div class="row" style="position: relative;top: -15px;left: 15px;">
          <div class="col-xs-8"></div>
          <div class="col-xs-1" style="position: relative; left: 40px;" id="pointer"></div>
          <div class="col-xs-3">
            <button name="select-columns" class="btn btn-primary btn-block btn-xs"
              style="font-size: 12px;margin-top:5px" id="select-columns">Select</button>

          </div>
        </div> <!-- .row (select btn) -->

      </form>
    </div>
    <?php }

    ?>

    <div class="tab-pane" id="parameter-mapping">

      <table class="table table-bordered text-center table-margin" id="parametersTable">
        <thead>
              <tr>
                <th class="table-header-primary vertical-align-middle text-center">Report</th>
                <th class="table-header-primary vertical-align-middle text-center">Parameter URL Key</th>
                <th class="table-header-primary vertical-align-middle text-center">Mapped Field</th>
                <th class="table-header-primary vertical-align-middle text-center" style="width: 15%;"></th>
              </tr>
          </thead>
          <tbody style="font-size: smaller;" id="parametersMappingTableBody">
          <?php
          if (is_array($parameters)) {
              foreach ($parameters as $key => $parameter) {
                  if (isset($parameter['params']) && is_array($parameter['params'])) {
                      foreach ($parameter['params'] as $param_key => $param_value) {
                          ?>
                          <tr data-id="<?php echo $key ?>" class="parameter-row">
                              <td class="vertical-align-middle parameter-body"><?php echo $parameter['name'] ?></td>
                              <td class="vertical-align-middle parameter-body"><?php echo $param_key ?></td>
                              <td class="vertical-align-middle parameter-body"><?php echo $param_value ?></td>
                              <td class="vertical-align-middle">
                                <button class="icon-btn btn btn-secondary btn-sm delete-btn" title="Delete">
                                    <span class="fa fa-trash-alt fa-fw"></span>
                                </button>
                              </td>
                          </tr>
                          <?php
                      }
                  } 
              }
          }

?>
          </tbody>
      </table>

      <!-- Form Section -->
      <form id="parameterForm" style="margin-top:20px;">
        <fieldset class="fieldset">
          <legend class="legend"><i class="fa fa-gear"></i> Parameter Mapping Settings</legend>
          <div class="row form-group">
              <div class="col-xs-5">
                  <label for="report">Reports</label>
                  <select class="form-control" id="report">
                      <option selected>Select report</option>
                  </select>
              </div>
              <div class="help-container col-xs-1">
                  <a href="" id="pmrHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
                  </a>
                </div>
              <div class="col-xs-5">
                  <label for="message">Link Message</label>
                  <input type="text" class="form-control" id="message" name="message">
              </div>
              <div class="help-container col-xs-1">
                <a href="" id="pmlmHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
                </a>
              </div>

          </div>


          <div class="row form-group" style="display: flex;justify-content: center;">
              <div class="col-xs-2">
                  <!-- <button class="btn btn-primary btn-block" id="saveParamBtn">Save Param</button> -->
                  <button class="btn btn-primary btn-block btn-xs" style="font-size: 12px; outline: none;" id="saveParamBtn">Save</button>
              </div>
              <div class="col-xs-2">
                  <!-- <button class="btn btn-clear btn-block" id="clearBtn">Clear</button> -->
                  <button class="btn btn-primary btn-block btn-xs" style="font-size: 12px; outline: none;" id="clearBtn">Clear</button>

              </div>
          </div>

              <!-- Hidden inputs container -->
          <div id="hiddenInputsContainer">
          <?php

if (is_array($parameters)) {
    foreach ($parameters as $key => $parameter) {
        ?>
                  <tr>
                      <input type="hidden" name="<?php echo $key ?>[id]" value="<?php echo $parameter['id'] ?>">
                      <input type="hidden" name="<?php echo $key ?>[message]" value="<?php echo $parameter['message'] ?>">
                      <?php
            // Handle params if they exist
            if (isset($parameter['params']) && is_array($parameter['params'])) {
                foreach ($parameter['params'] as $paramKey => $paramValue) {
                    ?>
                              <input type="hidden" name="<?php echo $key ?>[params][<?php echo $paramKey ?>]" value="<?php echo $paramValue ?>">
                              <?php
                }
            }
        ?>
                  </tr>
                  <?php
    }
}

?>
          </div>
        </fieldset>
      </form>

      <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="deleteModalLabel">
                        <span class="glyphicon glyphicon-warning-sign text-warning"></span>
                        Confirm Delete
                    </h4>
                </div>
                <div class="modal-body">
                    <p style="font-size: smaller;">Are you sure you want to delete the parameter <strong id="parameterToDelete"></strong>?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                        <span class="glyphicon glyphicon-trash"></span>
                        Delete
                    </button>
                </div>
            </div>
        </div>
      </div>
    </div>

    <div class="tab-pane" id="labels">

      <?php if($datasource !== "table"){?>
      <select id="selectedFieldsHidden" style="display: none;" >
        <?php foreach ($labels as $key => $val) {?>
          <option value="<?php echo $key ?>"><?php echo $val ?></option>
        <?php }?>
      </select>
      <?php }?>
      <form name="labelForm" id="labelForm" role="form" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>"
        onsubmit="return false;">
        <div class="row">
          <div id="labels-error-container" class="col-xs-12"></div>
        </div><!-- .row (error) -->

        <div class="row row-as-ftr">
          <div class="col-xs-1"></div>
          <div class="row col-xs-10 div-as-th">
            <div class="col-xs-6">Field</div>
            <div class="col-xs-6">Label</div>
          </div>
          <div class="col-xs-1"></div>
        </div>
        <div class="row" style="min-height: 190px;">
          <div class="col-xs-1"></div>
          <div class="col-xs-10 table-container">
            <table id="labels-table" class="table table-hover">
              <?php

    foreach ($labels as $key => $val) {?>
              <tr>
                <td style="width: 50%;"><label
                    for="lbl_<?php echo str_replace(array('.', ' '), array('_', '_'), $key); ?>"><?php echo $key; ?></label>
                </td>
                <td style="width: 50%;">
                  <div class="left-inner-addon">
                    <i class="glyphicon glyphicon-edit"></i>
                    <input class="input-as-tf" type="text" value="<?php echo $val; ?>"
                      id="lbl_<?php echo str_replace(array('.', ' '), array('_', '_'), $key); ?>"
                      name="lbl_<?php echo str_replace(array('.', ' '), array('_', '_'), $key); ?>" />
                  </div>
                </td>
              </tr>
              <?php }

    ?>
            </table>
          </div>
          <div class="col-xs-1"></div>
        </div>
      </form>
    </div>
    <?php

    if ($datasource === "table") {?>
    <div class="tab-pane" id="statistical">

      <form method="post" action="Statistical.php" role="form" onsubmit="return false;">
        <!-- Statistical options -->
        <div class="row">
          <div class="col-xs-1"></div>
          <div id="statistical-error-container" class="col-xs-10">
          </div>
          <div class="col-xs-1"></div>
        </div><!-- .row (error) -->
        <div class="row">
          <div class="col-xs-1"></div>
          <div class="form-group col-xs-10">
            <label for="functions">Statistical Function</label>
            <div class="left-inner-addon">
              <i class="glyphicon glyphicon-pushpin"></i>
              <select name="functions" class="form-control font-size-lg" id="functions">
                <?php

              foreach ($functions as $func) {

                  if (isset($_SESSION[Session_report_Settings_key]["function"]) && $_SESSION[Session_report_Settings_key]["function"] === $func) {
                      echo "<option value='$func' selected>$func</option>";
                  } else {
                      echo "<option value='$func'>$func</option>";
                  }

              }

        ?>
              </select>
            </div>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="statisticalFuncHelp" onClick="return false;">
              <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>
        </div><!-- .row (select function) -->

        <div class="row">
          <div class="col-xs-1"></div>
          <div class="form-group col-xs-10">
            <label for="affected_column">Affected column</label>
            <div class="left-inner-addon">
              <i class="glyphicon glyphicon-pushpin"></i>
              <select name="affected_column" class="form-control font-size-lg" id="affected_column">

                <?php

            foreach ($selectedFields as $field) {

                if (isset($_SESSION[Session_report_Settings_key]["affected_column"]) && $_SESSION[Session_report_Settings_key]["affected_column"] === $field) {
                    echo "<option value='$field' selected>$field</option>";
                } else {
                    echo "<option value='$field'>$field</option>";
                }

            }

        ?>
              </select>
            </div>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="statisticalColHelp" onClick="return false;">
              <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>
        </div><!-- .row (select column) -->

        <div class="row">
          <div class="col-xs-1"></div>
          <div class="form-group col-xs-10">
            <label for="groupby_column">Group By</label>
            <div class="left-inner-addon">
              <i class="glyphicon glyphicon-pushpin"></i>
              <select name="groupby_column" class="form-control font-size-lg" id="groupby_column">

                <?php

            if (isset($_SESSION[Session_report_Settings_key]["fields"]) && count($_SESSION[Session_report_Settings_key]["fields"]) === 1) {

                if (!isset($_SESSION[Session_report_Settings_key]["groupby_column"])) {
                    echo "<option value='None' selected>None</option>";
                } else {
                    echo "<option value='None'>None</option>";
                }

            }

        foreach ($selectedFields as $field) {

            if (isset($_SESSION[Session_report_Settings_key]["groupby_column"]) && $field === $_SESSION[Session_report_Settings_key]["groupby_column"]) {
                echo "<option value='$field' selected>$field</option>";
            } else {
                echo "<option value='$field'>$field</option>";
            }

        }

        ?>
              </select>
            </div>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="statisticalGroHelp" onClick="return false;">
              <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>
        </div><!-- .row (select group by) -->

        <div class="row" style="position: relative;top: -10px;">
          <div class="col-xs-8"></div>
          <div class="col-xs-3">
            <button name="set-statistical" class="btn btn-primary btn-block btn-xs" style="font-size: 12px;"
              id="set-statistical">
              <?php

          if (isset($_SESSION[Session_report_Settings_key]["statestical"]) && $_SESSION[Session_report_Settings_key]["statestical"] === 1) {
              echo 'Unset Function';
          } else {
              echo 'Set Function';
          }

        ?>
            </button />
          </div>
          <div class="col-xs-1"></div>
        </div>

      </form>
    </div>
    <?php }

    ?>
    </div>
      <div class="alert alert-danger" id="validationAlert" style="display: none;">
      <span id="validationMessage"></span>
    </div>
                        <?php

  if ($_SESSION[Session_wizard_key]["edit_mode"]) {?>
  <div class="alert alert-info">
    <div class="row">
      <div class="col-xs-1" style="margin-right: -17px;margin-top: 5px;">
        <i class="fa fa-info-circle fa-fw"></i>
      </div>
      <div class="col-xs-11">

        <span style="font-size: smaller;">If you make changes to saved options at any point, remember to click
          'Next' on that step to ensure your changes are saved</span>
      </div>
    </div>
  </div>
  <?php }

  ?>
  </div>




  <div class="row" style="margin-top:10px">
    <div class="col-xs-1"></div>
    <div class="col-xs-4">
      <button name="btn_back" id="btn_back" class="btn btn-sunny btn-block">
        <span class="icon glyphicon glyphicon-backward"></span><span class="separator"></span> Back
      </button>
    </div>
    <div class="col-xs-3"></div>
    <div class="col-xs-4">
      <button name="continue" id="btn_cont" class="btn btn-sunny btn-block">
        <span class="icon glyphicon glyphicon-forward"></span><span class="separator"></span> Next
      </button>
    </div>
  </div><!-- .row (navigation buttons) -->
</div>
<!-- end of the page -->
<!-- to complete index tags -->
</div>
</div>
</div>
</div>
<!-- end index tags -->
<script language="javascript">
var fieldsInfo =                                 <?php

                                     if (count($allFields) > 0) {
                                         echo 'new Array("' . implode('", "', $allFields) . '")';
                                     } else {
                                         echo 'new Array()';
                                     }

?>;

var s_selectedFields =                                             <?php

                if (isset($_SESSION[Session_report_Settings_key]["fields"])) {
                    echo 'new Array("' . implode('", "', $_SESSION[Session_report_Settings_key]["fields"]) . '")';
                } else {
                    echo "''";
                }

?>;

var c_selectedFields = new Array();

$(function() {

  
  loadReports();



  $("#tabs").tabs();



  $("#page-header").empty();
  $("#page-header").append(
    '<div id="img-container"><img src="includes/images/columns.jpg" width="70" height="70"/></div>');
  $("#page-header").append(
    '<div id="text-container"><h4>Select Columns</h4>You must select at least One column</div>');

  $("#columns-nav").click(function() {

    $("#page-header").empty();
    $("#page-header").append(
      '<div id="img-container"><img src="includes/images/columns.jpg" width="70" height="70"/></div>');
    $("#page-header").append(
      '<div id="text-container"><h4>Select Columns</h4>You must select at least One Column</div>');

  });


  $("#statistical-nav").click(function(e) {
    if (c_selectedFields.length > 0 || s_selectedFields !== "") {
      $("#page-header").empty();
      $("#page-header").append(
        '<div id="img-container"><img src="includes/images/Statistics.jpg" width="70" height="70"/></div>');
      $("#page-header").append(
        '<div id="text-container"><h4>Aggregation Functions</h4>It\'s not obligatory using it</div>');
    } else {
      e.preventDefault();
      $("#columns-nav").click();
      alertify.error("Please select columns before this step");
      return;
    }
  });

  <?php

  if ($datasource === "table") {?>
  $("#labels-nav, #parameter-mapping-nav").click(function(e) {
    
    if (c_selectedFields.length > 0 || s_selectedFields !== "") {
      $("#page-header").empty();
      $("#page-header").append(
        '<div id="img-container"><img src="includes/images/labels.jpg" width="70" height="70"/></div>');
      $("#page-header").append(
        '<div id="text-container"><h4>Change Labels</h4>change columns names displayed in report</div>');
    } else {
      e.preventDefault();
      $("#columns-nav").click();
      alertify.error("Please select columns before this step");
      return;
    }
  });
  <?php }

  ?>


  $("#allFields, #selectedFields, #add, #remove, #addAll, #removeAll").mousedown(function() {
    // alertify.error("Don't forget to click Select after choosing tables");
    if ($("#pointer-x").length <= 0) {
      $("#pointer").append(
        "<span id='pointer-x' class='invert-direction glyphicon glyphicon-arrow-left'> </span>");
      animatePointerX();
    }
  });


  if (s_selectedFields === "" || ($.isArray(s_selectedFields) && s_selectedFields.length < 1)) {
    $("#btn_cont").prop("disabled", true);
  }

  <?php

  if (online_demo_mode === 0): ?>

  $("#add").mousedown(function() {
    add("allFields", "selectedFields");
  });

  $("#remove").mousedown(function() {
    remove("selectedFields", "allFields", fieldsInfo);
  });

  $("#addAll").mousedown(function() {
    addAll("allFields", "selectedFields");
  });

  $("#moveUp").mousedown(function() {
    moveUp()
  });

  $("#moveDown").mousedown(function() {
    moveDown();
  });

  $("#removeAll").mousedown(function() {
    removeAll("selectedFields", "allFields", fieldsInfo);
  });

  $("#select-columns").mousedown(function() {
    $("#selectedFields option").prop("selected", true);
    var selectedFields = $("#selectedFields").val();
    var selectedFieldsAjax = (selectedFields !== null) ? selectedFields.join() : null;
    $("#parametersMappingTableBody tr").remove();
    checkEmptyTable();
    $("#hiddenInputsContainer input").remove();
    //sendHiddenInputsAjax();
    
    $.ajax({
      url: "services/step_4.php",
      type: "post",
      data: "selFields=" + selectedFieldsAjax,
      success: function(data) {
        data = data.toString().trim();
        $("#error-container").empty();
        $("#affected_column").empty();
        $("#groupby_column").empty();
        $("#labels-table").empty();
        $("#pointer-x").stop();
        $("#pointer-x").remove();
        if (data.includes("success")) {
          if ($.isArray(selectedFields)) {
            if (selectedFields.length === 1)
              $("#groupby_column").append("<option value='None'>None</option>");

            for (var i = 0; i < selectedFields.length; i++) {
              $("#affected_column").append("<option value='" + selectedFields[i] + "'>" + selectedFields[
                i] + "</option>");
              $("#groupby_column").append("<option value='" + selectedFields[i] + "'>" + selectedFields[
                i] + "</option>");

              var key = selectedFields[i].replace('.', '_');
              var chunks = selectedFields[i].split('.');
              var val = (selectedFields[i].indexOf('.') === -1) ? selectedFields[i] : chunks[1];
              $("#labels-table").append("<tr><td style='width: 50%;'><label for='lbl_" + key.replace(' ',
                  '_') + "'>" + selectedFields[i] + "</label></td>" +
                "<td style='width: 50%;'><div class='left-inner-addon'><i class='glyphicon glyphicon-edit'></i>" +
                "<input class='input-as-tf' type='text' value='" + val + "' id='lbl_" + key.replace(' ',
                  '_') + "' name='lbl_" + key.replace(' ', '_') + "' /></div></td></tr>"
              );
            }
          }
          c_selectedFields = selectedFields;
          $("#btn_cont").prop("disabled", false);
          <?php if ($isParentOrIntermediate) {?>
            $("#parameter-mapping-nav").trigger("click");
          <?php } else {?>
            $("#labels-nav").trigger("click");
          <?php }?>
        } else {
          $("#error-container").append(
            "<div class='alert alert-danger'>* At least One field should be selected " + data + "</div>"
          );
          $("#btn_cont").prop("disabled", true);
        }
      }
    });
  });

  $("#set-statistical").mousedown(function() {
    var functions = $("#functions").val();
    var affectedColumn = $("#affected_column").val();
    var groupbyColumn = $("#groupby_column").val();
    $("#statistical-error-container").empty();
    if (functions === "" || functions === null || typeof functions === "undefined") {
      $("#statistical-error-container").append(
        "<div class='alert alert-danger'>* Please select a function</div>");
      return;
    } else if (affectedColumn === "" || affectedColumn === null || typeof affectedColumn === "undefined") {
      $("#statistical-error-container").append(
        "<div class='alert alert-danger'>* Please select an affected column</div>");
      return;
    } else if (groupbyColumn === "" || groupbyColumn === null || typeof groupbyColumn === "undefined") {
      $("#statistical-error-container").append(
        "<div class='alert alert-danger'>* Please select a group by column</div>");
      return;
    } else if (groupbyColumn === affectedColumn) {
      $("#statistical-error-container").append(
        "<div class='alert alert-danger'>* Affected column and Group by can't be the same, Please pick another Affected column or Group by</div>"
      );
      return;
    }
    $.ajax({
      url: "services/step_4.php",
      type: "post",
      data: "func=" + functions + "&affectedColumn=" + affectedColumn + "&groupbyColumn=" + groupbyColumn,
      success: function(data) {
        data = data.trim();
        if (data === "success") {
          alertify.success("Aggregation function set successfully");
          $("#set-statistical").text('Unset Function');
        } else if (data === "unset_success") {
          alertify.success("Unset aggregation function success");
          $("#set-statistical").text('Set Function');
        } else {
          if (data === "error1")
            $("#statistical-error-container").append(
              "<div class='alert alert-danger'>* Please select a function</div>");
          else if (data === "error2")
            $("#statistical-error-container").append(
              "<div class='alert alert-danger'>* Please select an affected column</div>");
          else if (data === "error3")
            $("#statistical-error-container").append(
              "<div class='alert alert-danger'>* Please select a group by column</div>");
          else if (data === "error4")
            $("#statistical-error-container").append(
              "<div class='alert alert-danger'>* Affected column and Group by can't be the same, Please pick another Affected column or Group by</div>"
            );
          else
            alertify.error("error");
        }
      }
    });
  });
  <?php endif; ?>


  $("#btn_cont").mousedown(function() {

    <?php
    if ($isParentOrIntermediate): ?>
    if(checkEmptyParametersMappingTable()){
      showValidationAlert("You must add at least one parameter mapping or change Report Relationship type");
      return;
    }
    <?php endif; ?>

    var labelsValues = $("#labelForm").serialize();
    if (s_selectedFields !== "" || $.isArray(c_selectedFields)) {
      $.ajax({
        url: "services/step_4.php",
        type: "post",
        data: "labels=true&" + labelsValues,
        success: function(data) {
          data = data.trim();
          $("#error-container").empty();
          $("#labels-error-container").empty();
          if (data === "success") {

            nextToPage("3");
            SwitchStatusDone();
          } else {
            if (data !== "error") {
              $("#labels-nav").trigger("click");
              $("#labels-error-container").append(
                "<div class='alert alert-danger'>The Label of column '" + data + "' is required.</div>");
            } else {
              $("#columns-nav").trigger("click");
              console.log("At least One field should be selected");
              
              $("#error-container").append(
                "<div class='alert alert-danger'>* At least One field should be selected</div>");
              $("#btn_cont").prop("disabled", true);
            }
            SwitchStatusError();
          }
        },
        error: function() {
          alertify.error("error");
        }
      });
    } else {
      $("#btn_cont").prop("disabled", true);
      return;
    }
  });

  $("#btn_back").mousedown(function() {
    backToPage("1");
  });



  // ADD: Event handler for report selection and parameter textbox creation
  $(document).on('change', '#report', function() {
      let selectedOption = $(this).find('option:selected');
      let parameters = selectedOption.data('parameters');

      // Clear existing parameter textboxes
      $('#dynamicParametersContainer').remove();

      if (parameters && parameters.length > 0) {
          createParameterComboBoxWithPlaceholder(parameters);
      }
  });

  function createParameterComboBoxWithPlaceholder(parameters) {
      let containerHtml = '<div id="dynamicParametersContainer">';

      // Get selected fields HTML and add disabled "Select fields" placeholder
      <?php if($datasource == "table"){?>
      selectedFields = $("#selectedFields").html();

      <?php }else{?>
      selectedFields = $("#selectedFieldsHidden").html();
        
      <?php }?>
      let selectOptions = '<option value="" selected>Select fields</option>' + selectedFields;

      // Process parameters in pairs (2 per row)
      for (let i = 0; i < parameters.length; i += 2) {
          containerHtml += '<div class="row form-group">';

          // First select in the row
          containerHtml += `
              <div class="col-xs-5">
                  <label for="param_${i}">${parameters[i]}</label>
                  <select class="form-control parameter-input"
                        id="param_${i}"
                        name="param_${parameters[i]}"
                        data-param-key="${parameters[i]}">
                        ${selectOptions}
                  </select>
              </div>
              <div class="col-xs-1">
              </div>
          `;

          // Second select in the row (if exists)
          if (i + 1 < parameters.length) {
              containerHtml += `
                  <div class="col-xs-5">
                      <label for="param_${i + 1}">${parameters[i + 1]}</label>
                      <select class="form-control parameter-input"
                            id="param_${i + 1}"
                            name="param_${parameters[i + 1]}"
                            data-param-key="${parameters[i + 1]}">
                            ${selectOptions}
                      </select>
                  </div>
                  <div class="col-xs-1">
                  </div>
              `;
          } else {
              // Fill remaining space if odd number of parameters
              containerHtml += '<div class="col-xs-6"></div>';
          }

          containerHtml += '</div>';
      }

      containerHtml += '</div>';

      // Insert the parameter selects after the report selection row
      $('.fieldset .row:first').after(containerHtml);
  }


  // Save Parameter functionality
  $('#saveParamBtn').click(function(e) {
    e.preventDefault();
    $('#validationAlert').hide();

    var formData = {
        id: $('#report').val(),
        report: $('#report option:selected').attr("data-name"),
        message: $('#message').val(),
    };
    

    const params = {};
    const selectboxes = $('select[id^="param_"]');
    selectboxes.each(function() {
      const paramKey = $(this).data('param-key');

      if($(this).find('option:selected').val() != '')
        params[paramKey] = $(this).find('option:selected').val();
    });

    const validationResult = validateForm(formData, params);
    if (!validationResult.isValid) {
        showValidationAlert(validationResult.message);
        return;
    }
    
    // if (!formData.id || !formData.report || !formData.message) {
    //     showValidationAlert('Please fill in all required fields: Report and Link Message');
    //     return;
    // }

    if(Object.keys(params).length === 0){
      addTableRow(formData);
    }else{
      Object.keys(params).forEach(function(key) {
          addTableRow(formData,key, params[key]);
      });
    }

    addHiddenInput(formData, params);



    $(".empty-message").remove();

    // Clear form
    clearForm();
    updateHiddenInputsDisplay();

    // Send AJAX request with all hidden input data
    sendHiddenInputsAjax();

  });



  // Clear form functionality
  $('#clearBtn').click(function(e) {
      e.preventDefault();
      clearForm();
      editingRowIndex = -1;
      $('#validationAlert').hide();
      $('#saveParamBtn').text('Save');
      $('.editing-row').removeClass('editing-row');
  });

  var rowToDelete;
  // Delete functionality
  $(document).on('click', '.delete-btn', function() {
      const row = $(this).closest('tr');

      const parameterKey = row.find('td:eq(1)').text();
      $('#validationAlert').hide();
      // Store the row to be deleted
      rowToDelete = row;

      // Update modal content
      $('#parameterToDelete').text(parameterKey);

      // Show the modal
      $('#deleteModal').modal('show');

  });

  // Confirm delete functionality
  $('#confirmDeleteBtn').click(function() {
    if (rowToDelete) {
        const rowId = rowToDelete.attr("data-id");

        rowToDelete.remove();
        
        removeParam(rowId, rowToDelete.find('td:eq(1)').text());
        updateHiddenInputsDisplay();
        sendHiddenInputsAjax();

        // Clear the stored row
        rowToDelete = null;

        // Hide the modal
        $('#deleteModal').modal('hide');

        // Check if table is empty
        checkEmptyTable();
    }
  });

  // Clear rowToDelete when modal is closed
  $('#deleteModal').on('hidden.bs.modal', function () {
      rowToDelete = null;
  });
  updateHiddenInputsDisplay();
  checkEmptyTable();

  <?php if(online_demo_mode):?>
    $('#confirmDeleteBtn').off("click");
    $('#saveParamBtn').off("click");
  <?php endif;?>
});

function removeParam(reportId, paramField) {

      // Check if there are any remaining params for this report
    const remainingParams = $(`#hiddenInputsContainer input[name^="${reportId}[params]"]`);
    
    // If only one or no params left, remove the entire report
    if (remainingParams.length <= 1) {
        removeEntireReport(reportId);
    }

    // Remove the specific parameter
    $(`#hiddenInputsContainer input[name="${reportId}[params][${paramField}]"]`).remove();
    

}

function removeEntireReport(reportId) {
    // Remove all inputs related to this report (id, message, and all params)
    $(`#hiddenInputsContainer input[name^="${reportId}"]`).remove();
}

function removeLastParam(reportId) {
    // This function removes the last remaining param and the entire report
    removeEntireReport(reportId);
}

// Alternative function if you want to remove by index/position
function removeParamByIndex(reportId, paramIndex) {
    // Get all param inputs for this report
    const paramInputs = $(`#hiddenInputsContainer input[name^="${reportId}[params]"]`);
    
    if (paramInputs.length > paramIndex) {
        // Remove the specific param at the index
        $(paramInputs[paramIndex]).remove();
        
        // Check remaining params
        const remainingParams = $(`#hiddenInputsContainer input[name^="${reportId}[params]"]`);
        if (remainingParams.length <= 1) {
            removeEntireReport(reportId);
        }
    }
}

// Utility function to get all param field names for a report
function getParamFields(reportId) {
    const paramFields = [];
    $(`#hiddenInputsContainer input[name^="${reportId}[params]"]`).each(function() {
        const inputName = $(this).attr('name');
        const matches = inputName.match(/^report_\d+\[params\]\[(\w+)\]$/);
        if (matches) {
            paramFields.push(matches[1]);
        }
    });
    return paramFields;
}

// Function to count remaining params for a report
function countRemainingParams(reportId) {
    return $(`#hiddenInputsContainer input[name^="${reportId}[params]"]`).length;
}


function sendHiddenInputsAjax() {
    let parent_linked_parameters = {};

    // Loop over each parameter group
    $('#hiddenInputsContainer').find('input[name^="report_"]').each(function() {
        let inputName = $(this).attr('name'); // example: report_192[id] or report_192[params][settings_value]
        let inputValue = $(this).val();

        // Extract Report_id and field structure
        let directFieldMatches = inputName.match(/^report_(\d+)\[(\w+)\]$/);
        let nestedFieldMatches = inputName.match(/^report_(\d+)\[params\]\[(\w+)\]$/);
        
        if (directFieldMatches) {
            // Handle direct fields like report_192[id] or report_192[message]
            let reportId = "report_" + directFieldMatches[1];
            let fieldName = directFieldMatches[2];

            if (!parent_linked_parameters[reportId]) {
                parent_linked_parameters[reportId] = {};
            }
            parent_linked_parameters[reportId][fieldName] = inputValue;
        } else if (nestedFieldMatches) {
            // Handle nested fields like report_192[params][settings_value]
            let reportId = "report_" + nestedFieldMatches[1];
            let fieldName = nestedFieldMatches[2];

            if (!parent_linked_parameters[reportId]) {
                parent_linked_parameters[reportId] = {};
            }
            if (!parent_linked_parameters[reportId]['params']) {
                parent_linked_parameters[reportId]['params'] = {};
            }
            parent_linked_parameters[reportId]['params'][fieldName] = inputValue;
        }
    });

    $.ajax({
        url: 'services/step_4.php',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ parent_linked_parameters: parent_linked_parameters }),
        success: function(response) {
        },
        error: function(xhr, status, error) {
        }
    });
}

function checkEmptyParametersMappingTable() {
  const dataRows = $('#parametersMappingTableBody tr:not(.empty-message)');
  if (dataRows.length === 0) {
    return true;
  }
  return false
}

function showValidationAlert(message) {
  $('#validationMessage').text(message);
  $('#validationAlert').slideDown();

}

function addHiddenInput(formElem, params) {
    const hiddenInputsHtml = `
        <input type="hidden" name="report_${formElem.id}[id]" value="${formElem.id}">
        <input type="hidden" name="report_${formElem.id}[name]" value="${formElem.report}">
        <input type="hidden" name="report_${formElem.id}[message]" value="${formElem.message}">
    `;
    $('#hiddenInputsContainer').append(hiddenInputsHtml);

    Object.keys(params).forEach(function(key) {

      $('#hiddenInputsContainer').append(`<input type="hidden" name="report_${formElem.id}[params][${key}]" value="${params[key]}">`);
    });

}

function checkEmptyTable() {
  const dataRows = $('#parametersMappingTableBody tr:not(.empty-message)');
  if (dataRows.length === 0) {
      showEmptyMessage();
  }
}

function showEmptyMessage() {
  const emptyRow = `
      <tr class="empty-message">
          <td colspan="5" class="parameter-body">
              No parameters have been mapped yet.
          </td>
      </tr>
  `;
  $('#parametersMappingTableBody').append(emptyRow);
}

function validateForm(formData, params) {
  
  if (!formData.id || formData.id == '' ||  formData.id == "Select report") {
      return { isValid: false, message: "Choose a report you wish to link to" };
  }

  if (!formData.message || formData.message == '' || formData.message.length > 50) {
      return { isValid: false, message: "Linking message must be filled in and should be under 50 characters" };
  }

  // Get existing values from hiddenInputsContainer
  const existingValues = getExistingParamValues(formData.id);
  
  // Combine existing values with new params
  const allValues = [...existingValues, ...Object.values(params)];
  
  if(hasDuplicateValues(allValues)){
      return { isValid: false, message: "You can't use the same field in multiple parameter in the same Report" };
  }

  return { isValid: true, message: "" };
}


function getExistingParamValues(reportId) {
    const existingValues = [];
    
    // Look for existing params in hiddenInputsContainer for the same report
    $('#hiddenInputsContainer').find(`input[name^="report_${reportId}[params]"]`).each(function() {
        const value = $(this).val();
        if (value) {
            existingValues.push(value);
        }
    });
    
    return existingValues;
}

function hasDuplicateValues(values) {
    const seen = new Set();
    for (const value of values) {
        if (seen.has(value)) {
            return true; // Duplicate found
        }
        seen.add(value);
    }
    return false; // No duplicates
}

function updateHiddenInputsDisplay() {
    const hiddenInputs = $('#hiddenInputsContainer input');
    if (hiddenInputs.length === 0) {
        $('#hiddenInputsDisplay').html('No hidden inputs yet');
    } else {
        let displayHtml = '';
        hiddenInputs.each(function() {
            displayHtml += `<div><strong>${$(this).attr('name')}:</strong> ${$(this).val()}</div>`;
        });
        $('#hiddenInputsDisplay').html(displayHtml);
    }
}
function addTableRow(formElem, key, paramElem) {

  let newRow ="";
  if(typeof key === 'undefined'){
      newRow = `
        <tr class="parameter-row" data-id="report_${formElem.id}">
            <td class="vertical-align-middle parameter-body">${formElem.report}</td>
            <td class="vertical-align-middle parameter-body"></td>
            <td class="vertical-align-middle parameter-body"></td>
            <td class="vertical-align-middle">
              <button class="icon-btn btn btn-secondary btn-sm delete-btn" title="Delete">
                  <span class="fa fa-trash-alt fa-fw"></span>
              </button>
            </td>
        </tr>
    `;

    }else{
      newRow = `
        <tr class="parameter-row" data-id="report_${formElem.id}" data-param="${key}">
            <td class="vertical-align-middle parameter-body">${formElem.report}</td>
            <td class="vertical-align-middle parameter-body">${key}</td>
            <td class="vertical-align-middle parameter-body">${paramElem}</td>
            <td class="vertical-align-middle">
              <button class="icon-btn btn btn-secondary btn-sm delete-btn" title="Delete">
                  <span class="fa fa-trash-alt fa-fw"></span>
              </button>
            </td>
        </tr>
    `;

    }
    $('#parametersMappingTableBody').append(newRow);
}

function loadReports(){
    $.ajax({
        url: "services/step_4.php",
        type: "post",
        data: "getAllReports=getAllReports",
        success: function(data) {
            let html = '';
            let reports = data;

            reports.forEach(function(report) {
                let parameters = JSON.parse(report.configuration.parameters);
                let keys = (parameters.linked && typeof parameters.linked === "object")
                    ? Object.values(parameters.linked).map(param => param.key)
                    : Object.values(parameters).map(param => param.key);
                
                html += `<option value="${report.id}" data-name="${report.name}" data-parameters='${JSON.stringify(keys)}'>${report.name}</option>`;
            });

            $('#report').append(html);
        }
    });
}

  function moveUp() {
    const select = document.getElementById("selectedFields");
    for (let i = 1; i < select.options.length; i++) {
      const option = select.options[i];
      if (option.selected && !select.options[i - 1].selected) {
        select.insertBefore(option, select.options[i - 1]);
      }
    }
  }

  function moveDown() {
    const select = document.getElementById("selectedFields");
    for (let i = select.options.length - 2; i >= 0; i--) {
      const option = select.options[i];
      if (option.selected && !select.options[i + 1].selected) {
        select.insertBefore(select.options[i + 1], option);
      }
    }
  }


function animatePointerX() {
  $("#pointer-x").animate({
    left: "+=10"
  }, 1000, function() {
    $("#pointer-x").animate({
      left: "-=10"
    }, 1000, function() {
      animatePointerX();
    });
  });
}

  function clearForm() {
      $('#parameterForm')[0].reset();
      $(".parameter-input").parent("div").remove();
  }


<?php

if (online_demo_mode === 1): ?>

$("#allFields, #selectedFields, #add, #remove, #addAll, #removeAll").mousedown(function() {
  // alertify.error("Don't forget to click Select after choosing tables");
  if ($("#pointer-x").length <= 0) {
    $("#pointer").append("<span id='pointer-x' class='invert-direction glyphicon glyphicon-arrow-left'> </span>");
    animatePointerX();
  }
});


if (s_selectedFields === "" || ($.isArray(s_selectedFields) && s_selectedFields.length < 1)) {
  $("#btn_cont").prop("disabled", true);
}

$("#moveUp").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

$("#moveDown").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

$("#add").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

$("#remove").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

$("#addAll").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

setTimeout(() => {
  $("#confirmDeleteBtn").click(function() {
    $('#deleteModal').modal('hide');
    alertify.error("Available Only in Full version.");
    return false;
  });

  $("#saveParamBtn").click(function() {
    alertify.error("Available Only in Full version.");
    return false;
  });

}, 1000);


$("#removeAll").mousedown(function() {
  alertify.error("Available Only in full version");
  return false;
});

$("#select-columns").mousedown(function() {

  $("#btn_cont").prop("disabled", false);
  <?php if ($isParentOrIntermediate) {?>
    $("#parameter-mapping-nav").trigger("click");
  <?php } else {?>
    $("#labels-nav").trigger("click");
  <?php }?>
});

$("#set-statistical").mousedown(function() {

  alertify.error("Available only in full version!");
  return false;

});

// labels
$(".input-as-tf").keydown(function(e) {
  e.preventDefault();
  alertify.error("Available only in full version!");
  return false;

})

// aggregation functions

var lastFunction = $("#functions option:selected");
$("#functions").on("change", function(e) {

  lastFunction.prop("selected", true);
  alertify.error("Available only in full version");
});

var lastAffectedColumn = $("#affected_column option:selected");
$("#affected_column").on("change", function(e) {

  lastAffectedColumn.prop("selected", true);
  alertify.error("Available only in full version");
});


var lastGroupByColumn = $("#groupby_column option:selected");
$("#groupby_column").on("change", function(e) {

  lastGroupByColumn.prop("selected", true);
  alertify.error("Available only in full version");
});

<?php endif?>



</script>