<?php
if (!defined('DIRECTACESS'))
    exit('No direct script access allowed');

$isParent       = $report_relation === "parent";
$isIntermediate = $report_relation === "intermediate";

if ($isParent || $isIntermediate) {
    $report_mapping         = $srm_dashboard->prepare_parameters_mapping($tables_parameters_mapping);
    $linked_reports_count   = count($report_mapping);
    $isParentOrIntermediate = !empty($report_mapping);
} else {
    $isParentOrIntermediate = false;
}

$hide_labels = !empty($field_settings['hide_field_label']);
$use_title   = !empty($field_settings['use_first_as_title']);

$non_group_fields = array_values(array_diff($actual_fields, $group_by));
$title_field      = $use_title && count($non_group_fields) ? $non_group_fields[0] : null;

// Convert result to array to handle pairs
$result_array = [];
foreach ($result as $row) {
    foreach ($calculated_columns as $key => $value) {
        $row[$key] = $value($row);
    }
    $result_array[] = $row;
}

/**
 * Helper: print records in pairs (equal height for two columns)
 */
function print_record_pairs($records, $actual_fields, $cells, $labels, $hide_labels, $title_field, $use_title, $isParentOrIntermediate, $report_mapping) {
    global $_CLEANED;
    $cur_row = 0;

    for ($record_index = 0; $record_index < count($records); $record_index += 2) {
        $row1 = $records[$record_index];
        $row2 = isset($records[$record_index + 1]) ? $records[$record_index + 1] : null;

        echo "<tr><td colspan='2'>";
        echo "<div style='display: flex; gap: 20px;align-items:stretch;'>";

        // First record
        echo "<div style='flex:1;display:flex; flex-direction:column;' class='full-backgroud'>";
        echo "<table width='100%' cellspacing='0' cellpadding='2' class='record-table'>";
        foreach ($actual_fields as $val) {
            if ($use_title && $val === $title_field) {
                $value = $row1[get_field_part($val, $row1)];
                echo "<tr><td colspan='2' style='text-align:center;' class='HColumnHeader'>";
                if (is_image_cell($cells[$val]) || is_barcode_cell($cells[$val])) {
                    echo render($value, $cells[$val], $val, false, false, true);
                } else {
                    echo "<span style='font-weight:bold; font-size:x-large;'>" 
                        . render($value, $cells[$val], $val, false, false, true) 
                        . "</span>";
                }
                echo "</td></tr>";
                continue;
            }

            if ($hide_labels || $cells[$val] == "image") {
                $value = $row1[get_field_part($val, $row1)];
                if ($cells[$val] == "image") {
                    echo "<tr><td align='left' colspan='2'>" . render($value, $cells[$val], $val, false, false, true) . "</td></tr>";
                } else {
                    echo "<tr><td align='left' colspan='2' class='HColumnHeader'>" . render($value, $cells[$val], $val, false, false, true) . "</td></tr>";
                }
            } else {
                $value = $row1[get_field_part($val, $row1)];
                echo "<tr><td align='left' class='HColumnHeader'>{$labels[$val]}</td><td class='HTableCell-horizontal'>" 
                    . render($value, $cells[$val], $val, false, false, true) 
                    . "</td></tr>";
            }
        }

        if ($isParentOrIntermediate) {
            echo "<tr>";
            if (!$hide_labels) echo "<td class='HColumnHeader'>More</td>";
            echo "<td class='HTableCell-horizontal'><div class='dropdown'>";
            echo "<span class='btn btn-default btn-sm dropdown-toggle' type='button' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>";
            echo "<span class='arrow-icon arrow-icon-horizontal'></span>";
            echo "</span>";
            echo "<ul class='dropdown-menu dropdown-menu-right-horizontal' style='max-width: 300px;'>";
            foreach ($report_mapping as $report_data) {
                $params_array = [];
                if (!empty($report_data['params'])) {
                    foreach ($report_data['params'] as $param_key => $param_value) {
                        $row_value = $row1[get_field_part($param_value, $row1)];
                        $params_array[] = urlencode($param_key) . "=" . urlencode($row_value);
                    }
                }
                $params_string = $params_array ? "?" . implode("&", $params_array) : "";

                if (isset($_CLEANED['token'])) {
                    $params_string .= ($params_string === "" ? "?" : "&") . "token=" . urlencode($_CLEANED['token']);
                }

                if (isset($_CLEANED['mode'])) {
                    $params_string .= ($params_string === "" ? "?" : "&") . "mode=embed";
                }

                $redirect_url = get_cur_url_report($report_data['url']) . $params_string;
                echo "<li><a href='$redirect_url'>" . htmlspecialchars($report_data['message']) . "</a></li>";
            }
            echo "</ul></div></td></tr>";
        }
        echo "</table></div>";

        // Second record
        if ($row2 !== null) {
            echo "<div style='flex:1;display:flex; flex-direction:column;' class='full-backgroud'>";
            echo "<table width='100%'  cellspacing='0' cellpadding='2' class='record-table'>";
            foreach ($actual_fields as $val) {
                if ($use_title && $val === $title_field) {
                    $value = $row2[get_field_part($val, $row2)];
                    echo "<tr><td colspan='2' style='text-align:center;' class='HColumnHeader'>";
                    if (is_image_cell($cells[$val]) || is_barcode_cell($cells[$val])) {
                        echo render($value, $cells[$val], $val, false, false, true);
                    } else {
                        echo "<span style='font-weight:bold; font-size:x-large;'>" 
                            . render($value, $cells[$val], $val, false, false, true) 
                            . "</span>";
                    }
                    echo "</td></tr>";
                    continue;
                }

                if ($hide_labels || $cells[$val] == "image") {
                    $value = $row2[get_field_part($val, $row2)];
                    if ($cells[$val] == "image") {
                        echo "<tr><td align='left' colspan='2'>" . render($value, $cells[$val], $val, false, false, true) . "</td></tr>";
                    } else {
                        echo "<tr><td align='left' colspan='2' class='HColumnHeader'>" . render($value, $cells[$val], $val, false, false, true) . "</td></tr>";
                    }
                } else {
                    $value = $row2[get_field_part($val, $row2)];
                    echo "<tr><td align='left' class='HColumnHeader'>{$labels[$val]}</td><td class='HTableCell-horizontal'>" 
                        . render($value, $cells[$val], $val, false, false, true) 
                        . "</td></tr>";
                }
            }

            if ($isParentOrIntermediate) {
                echo "<tr>";
                if (!$hide_labels) echo "<td class='HColumnHeader'>More</td>";
                echo "<td class='HTableCell-horizontal'><div class='dropdown'>";
                echo "<span class='btn btn-default btn-sm dropdown-toggle' type='button' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>";
                echo "<span class='arrow-icon arrow-icon-horizontal'></span>";
                echo "</span>";
                echo "<ul class='dropdown-menu dropdown-menu-right-horizontal' style='max-width: 300px;'>";
                foreach ($report_mapping as $report_data) {
                    $params_array = [];
                    if (!empty($report_data['params'])) {
                        foreach ($report_data['params'] as $param_key => $param_value) {
                            $row_value = $row2[get_field_part($param_value, $row2)];
                            $params_array[] = urlencode($param_key) . "=" . urlencode($row_value);
                        }
                    }
                    $params_string = $params_array ? "?" . implode("&", $params_array) : "";

                    if (isset($_CLEANED['token'])) {
                        $params_string .= ($params_string === "" ? "?" : "&") . "token=" . urlencode($_CLEANED['token']);
                    }

                    $redirect_url = get_cur_url_report($report_data['url']) . $params_string;
                    echo "<li><a href='$redirect_url'>" . htmlspecialchars($report_data['message']) . "</a></li>";
                }
                echo "</ul></div></td></tr>";
            }
            echo "</table></div>";
        } else {
            echo "<div style='flex:1;'>&nbsp;</div>";
        }

        echo "</div>"; // close flex
        echo "</td></tr>";

        echo "<tr><td colspan='2' style='height: 20px;'>&nbsp;</td></tr>";
        $cur_row += ($row2 !== null) ? 2 : 1;
    }
}

// --- Grouping ---
$current_group_key = null;
$group_records = [];

foreach ($result_array as $row) {
    $group_key_parts = [];
    foreach ($group_by as $val) {
        $group_key_parts[] = $row[get_field_part($val, $row)];
    }
    $group_key = implode('|', $group_key_parts);

    if ($group_key !== $current_group_key) {
        if ($group_records) {
            print_record_pairs($group_records, $actual_fields, $cells, $labels, $hide_labels, $title_field, $use_title, $isParentOrIntermediate, $report_mapping);
            $group_records = [];
        }

        echo "<tr><td class='MainGroup' colspan='" . ((count($actual_fields) * 2) + 2) . "'>";
        foreach ($group_by as $i => $val) {
            echo $labels[$val] . ": " . render($row[get_field_part($val, $row)], $cells[$val], $val) . "&nbsp;&nbsp;";
        }
        echo "</td></tr>";

        $current_group_key = $group_key;
    }

    $group_records[] = $row;
}

if ($group_records) {
    print_record_pairs($group_records, $actual_fields, $cells, $labels, $hide_labels, $title_field, $use_title, $isParentOrIntermediate, $report_mapping);
}

if (!empty($footer)) {
    echo "<tr><td>$footer</td></tr>";
}

function is_image_cell($cellType) {
    return in_array($cellType, ['image', 'main-image']);
}
function is_barcode_cell($cellType) {
    return in_array($cellType, ['barcode', 'qr']);
}
?>
