<?php

/**
 * Smart Report Engine
 * Version 2.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : https://mysqlreports.com/
 *
 */

if (!defined("DIRECTACESS")) {
    exit("No direct script access allowed");
}

class TableReport extends Report
{
    protected $table;
    protected $affected_column;
    protected $groupby_column;
    protected $relationships;
    protected $tables_filters;
    protected $url_parameters;
    protected $search;
    protected $funcations_arr;
    protected $filters_grouping;

    public function __construct($table, $fields, $relationships = array(), $tables_filter = array(), $url_parameters = array(), $search_options = null, $filters_grouping = "and")
    {

        $this->set_search_options($search_options);
        $this->set_relasions($relationships);
        $this->set_filters($tables_filter);
        $this->set_url_parameters($url_parameters);
        $this->set_table($table);
        $this->set_fields($fields);
        $this->filters_grouping = (strtolower($filters_grouping) == "or") ? "or" : "and";

        $this->funcations_arr = array(
            "sum(",
            "avg(",
            "min(",
            "max(",
            "count("
        );

    }

    public function set_table($table)
    {

        if (is_array($table)) {
            $this->table = $table;
        } else {
            $this->table = array();
        }

    }

    public function set_relasions($relasions)
    {

        if (is_array($relasions)) {
            $this->relationships = $relasions;
        } else {
            $this->relationships = array();
        }

    }

    public function set_search_options($search)
    {

        if (!is_null($search) && get_class($search) == "Search_options") {
            $this->search = $search;
        } else {
            $this->search = null;
        }

    }

    public function set_filters($filters)
    {

        if (is_array($filters)) {
            $this->tables_filters = $filters;
        } else {
            $this->tables_filters = array();
        }

    }

    public function set_url_parameters($url_parameters)
    {

        if (is_array($url_parameters)) {
            $this->url_parameters = $url_parameters;
        } else {
            $this->url_parameters = array();
        }

    }

    public function set_affected_column($affected_column)
    {
        $this->affected_column = $affected_column;
    }

    public function set_groupby_column($groubby_column)
    {
        $this->groupby_column = $groubby_column;
    }

// Helper function to check if a value is a datetime format
    private function isDateTimeFormat($value)
    {

        if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/', $value)) {
            return true;
        }


        return false;
    }

    private function isDateFormat($value)
    {



        if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $value)) {
            return true;
        }

        return false;
    }

// Helper function to create date range conditions for whole day
    private function createDateRangeCondition($column, $dateTimeValue, &$parameters, &$types)
    {
        // Extract just the date part (Y-m-d)
        $dateOnly = date('Y-m-d', strtotime($dateTimeValue));

        // Create start and end of day
        $startOfDay = $dateOnly . ' 00:00:00';
        $endOfDay   = $dateOnly . ' 23:59:59';

        if (preg_match('/^[a-zA-Z_][a-zA-Z0-9_]*\.[a-zA-Z_][a-zA-Z0-9_]*$/', $column)) {
            $column = explode(".", $column);
            $condition = "`$column[0]`.`$column[1]` >= ? AND `$column[0]`.`$column[1]` <= ?";
        }else{
            $condition = "`$column` >= ? AND `$column` <= ?";
        }

        // Add parameters
        $parameters[] = $startOfDay;
        $parameters[] = $endOfDay;

        // Add types (assuming string type)
        $types .= "ss";
        return $condition;
    }

    public function Prepare_Sql()
    {
        global $_URL_PARAMETERS, $tables_parameters;

        $url_parameters     = $_URL_PARAMETERS['parameters'];
        $filter_params      = array();
        $filter_param_types = "";
        //All (filters + search) parameters and parameters types .
        $parameters = array();
        $types      = "";

        $sql = "select ";
        $c   = 0;

        foreach ($this->fields as $f) {

            if (count($this->table) != 1) {
                // Check if this is a function field
                $isFunction = 0;

                foreach ($this->funcations_arr as $key => $val) {

                    if (strstr($f, $val)) {
                        $isFunction = 1;
                        break;
                    }

                }

                $temp = explode(".", $f);
                $t    = $temp[0]; // Table name
                $f    = $temp[1];

// Column name

                if ($isFunction == 1) {
                    $sql .= "$t`.`$f ";
                    $sql .= " as '$t.$f'";
                } else {
                    $sql .= "`$t`.`$f` ";
                    $sql .= " as '$t.$f'";
                }

            } else {
                $isFunction = 0;
                foreach ($this->funcations_arr as $key => $val) {
                    if (strstr($f, $val)) {
                        $isFunction = 1;
                        break;
                    }

                }

                if ($isFunction == 0) {
                    $sql .= "`$f`";
                } else {
                    $sql .= "$f";
                }

            }

            if ($c < (count($this->fields) - 1)) {
                $sql .= ",";
            }

            $c++;
        }

        // add tables names
        $sql .= " from ";

        foreach ($this->table as $key => $val) {
            $sql .= "`$val`,";
        }

        $sql = substr($sql, 0, strlen($sql) - 1);

// add relations
        if (!empty($this->relationships) && count($this->relationships) > 0) {
            $sql .= " where";
            foreach ($this->relationships as $key => $val) {
                $sql .= " $val" . " and";
            }

            $sql = substr($sql, 0, strlen($sql) - 3);
        }

        if (count($this->tables_filters) > 0) {
            if (count($this->relationships) > 0) {
                $sql .= " and";
            } else {
                $sql .= " where ";
            }

            foreach ($this->tables_filters as $k => $filter) {

                if (!is_array($filter["param"])) {

                    if (strstr(strtolower($filter["param"]), "todate")) {
                        $filter = $this->edit_is_today_filter($filter);
                    }

                    if (strstr(strtolower($filter["param"]), "year")) {
                        $filter = $this->edit_is_current_year($filter);
                    }

                    if (strstr(strtolower($filter["param"]), "month")) {
                        $filter = $this->edit_is_current_month($filter);
                    }

                    if (strstr(strtolower($filter["param"]), "quarter")) {
                        $filter = $this->edit_is_current_quarter($filter);
                    }

                }

                foreach ($filter as $key => $value) {

                    if ($key == "sql") {
                        $is_filter_contains_parameter = (strstr($value, "?")) ? true : false;
                        $newvalue                     = str_replace("\\", " ", $value);
                        $newvalue                     = str_replace("` <->", "", $newvalue);
                        $newvalue                     = str_replace("<->", " ", $newvalue);
                        $newvalue                     = str_replace("\\", "", $newvalue);
                        if ($this->filters_grouping == "or") {
                            $sql .= " ( $newvalue )" . "  or";
                        } else {
                            $sql .= " ( $newvalue )" . " and";
                        }

                    }

                    if ($is_filter_contains_parameter && $key == "param" && !is_array($value)) {

                        $filter_params[] = $value;
                    } elseif ($is_filter_contains_parameter && $key == "param" && is_array($value)) {
                        $filter_params = array_merge($filter_params, $value);
                    }

                    if ($is_filter_contains_parameter && $key == "type") {
                        $filter_param_types .= $value;
                    }

                }

            }

            $sql        = substr($sql, 0, strlen($sql) - 3);
            $parameters = $filter_params;
            $types      = $filter_param_types;
        }

        if (!empty($tables_parameters) && is_array($tables_parameters)) {
            $url_filter_conditions = array();

            foreach ($tables_parameters as $param_key => $param_config) {
                if (is_array($param_config) && isset($param_config['column']) && isset($param_config['key'])) {
                    $column   = $param_config['column'];
                    $key      = $param_config['key'];
                    $if_empty = isset($param_config['if_empty']) ? $param_config['if_empty'] : '';
                    $default  = isset($param_config['default']) ? $param_config['default'] : '';

                    if (isset($url_parameters[$key])) {
                        $value = $url_parameters[$key];

// Handle dynamic datetime values
                        if ($value === "Current DateTime - Dynamic") {
                            $value = date('Y-m-d H:i:s');
                        } elseif ($value === "Current Date - Dynamic") {
                            $value = date('Y-m-d');
                        } elseif ($value === "Current Time - Dynamic") {
                            $value = date('H:i:s');
                        }

                        if (!empty($value)) {

// Handle column name based on relationships
                            if (empty($this->relationships) && count($this->table) == 1) {

// No relationships and single table - remove table prefix
                                if (strpos($column, '.') !== false) {
                                    $column_parts = explode('.', $column);
                                    $column       = $column_parts[1]; // Take only the column name
                                }

                            }

// Check if value is in datetime format for whole day matching
                            if ($this->isDateFormat($value)) {
                                $url_filter_conditions[] = $this->createDateRangeCondition($column, $value, $parameters, $types);
                            }else{
                                // Regular exact match for non-datetime values
                                if (preg_match('/^[a-zA-Z_][a-zA-Z0-9_]*\.[a-zA-Z_][a-zA-Z0-9_]*$/', $column)) {
                                    $column = explode(".", $column);
                                    $url_filter_conditions[] = "`$column[0]`.`$column[1]` = ?";
                                }else{
                                    $url_filter_conditions[] = "`$column` = ?";
                                }
                                $parameters[]            = $value;
                                $types .= "s"; // assuming string type, adjust as needed
                            }

                        }

                    } else {

// Key doesn't exist in URL parameters
                        if ($if_empty == 'default' && !empty($default)) {

// Handle dynamic default values
                            if ($default === "Current DateTime - Dynamic") {
                                $default = date('Y-m-d H:i:s');
                            } elseif ($default === "Current Date - Dynamic") {
                                $default = date('Y-m-d');
                            } elseif ($default === "Current Time - Dynamic") {
                                $default = date('H:i:s');
                            }

// Handle column name based on relationships
                            if (empty($this->relationships) && count($this->table) == 1) {

// No relationships and single table - remove table prefix
                                if (strpos($column, '.') !== false) {
                                    $column_parts = explode('.', $column);
                                    $column       = $column_parts[1]; // Take only the column name
                                }

                            }

// Check if default value is in datetime format for whole day matching
                            if ($this->isDateTimeFormat($default)) {
                                $url_filter_conditions[] = $this->createDateRangeCondition($column, $default, $parameters, $types);
                            } else {
                                // Regular exact match for non-datetime values
                                if (preg_match('/^[a-zA-Z_][a-zA-Z0-9_]*\.[a-zA-Z_][a-zA-Z0-9_]*$/', $column)) {
                                    $column = explode(".", $column);
                                    $url_filter_conditions[] = "`$column[0]`.`$column[1]` = ?";
                                }else{
                                    $url_filter_conditions[] = "`$column` = ?";
                                }

                                // $url_filter_conditions[] = "`$column` = ?";
                                $parameters[]            = $default;
                                $types .= "s"; // assuming string type, adjust as needed
                            }

                        }

                        // If if_empty is not 'default' or default is empty, ignore it
                    }

                }

            }

// Add URL filter conditions to SQL if any exist
            if (!empty($url_filter_conditions)) {
                $url_filter_sql = "(" . implode(" AND ", $url_filter_conditions) . ")";

// Determine where to add the URL filter
                if (!empty($this->relationships) || count($this->tables_filters) > 0) {
                    $sql .= " AND " . $url_filter_sql;
                } else {
                    $sql .= " WHERE " . $url_filter_sql;
                }

            }

        }

        if (!is_null($this->search)) {
            if ($this->search->search_type == "quick") {

                $search_array = $this->search->prepare_ordinary_search_statment($this->table, $this->fields);
            } elseif ($this->search->search_type == "advanced") {
                $search_array = $this->search->prepare_advanced_search_statment();
            }

        }

        if (isset($search_array) && !empty($search_array)) {
            if (is_array($search_array)) {
                //case filter and search
                $search_sql = $search_array["sql"];
                $parameters = array_merge($parameters, $search_array["parameters"]);
                $types      = $types . $search_array["types"];
            } else {

                $search_sql = $search_array;
            }

            if (!empty($this->relationships) || count($this->tables_filters) > 0) {
                $sql .= " and " . $search_sql;
            } else {
                $sql .= " where " . $search_sql;
            }

        }

// group by in case of statistics
        if (!empty($this->groupby_column)) {

            $grp_ar = explode(".", $this->groupby_column);

            if (count($grp_ar) > 1) {
                $sql .= " group by (`" . $grp_ar[0] . "`.`" . $grp_ar[1] . "`) ";
            } else {
                $sql .= " group by (`" . $grp_ar[0] . "`) ";
            }

        }

        if (count($this->sort_by) > 0 || count($this->group_by) > 0) {
            $sql .= " order by ";
        }

        $group_by_sort = array();
        foreach ($this->group_by as $g) {
            $flag = 0;
            $i    = 0;

            foreach ($this->sort_by as $arr) {
                if ($g == $arr[0]) {
                    $group_by_sort[] = array(
                        $arr[0],
                        $arr[1]
                    );
                    $flag                 = 1;
                    $this->sort_by[$i][0] = '~xxx~';
                    break;
                }

                $i++;
            }

            if ($flag == 0) {
                $group_by_sort[] = array(
                    $g,
                    '0'
                );
            }

        }

        foreach ($this->sort_by as $arr_sort) {
            if ($arr_sort[0] != '~xxx~') {
                $group_by_sort[] = array(
                    $arr_sort[0],
                    $arr_sort[1]
                );
            }

        }

        $i = 0;

        foreach ($group_by_sort as $arr) {
            if (count($this->table) != 1) {

                $dummy = explode(".", $arr[0]);

                $sql .= "`" . $dummy[0] . "`.`" . $dummy[1] . "`";
            } else {
                $sql .= "`" . $arr[0] . "`";
            }

            if ($arr[1] == '1') {
                $sql .= "desc";
            }

            if ($i < (count($group_by_sort) - 1)) {
                $sql .= ",";
            }

            $i++;
        }

        $new_fields   = array();
        $new_sort_by  = array();
        $new_group_by = array();

// fields
        foreach ($this->fields as $key => $val) {
            // check if it's function field
            $isFunction = 0;

            foreach ($this->funcations_arr as $key1 => $val1) {

                if (strstr($val, $val1)) {
                    $isFunction = 1;
                    break;
                }

            }

            if (strstr($val, ".")) {
                list($t, $f) = explode(".", $val);
            } else {
                $f = $val;
            }

            if ($isFunction == 1) {
                $new_fields[] = substr($f, 0, strlen($f) - 2);
            } else {
                $new_fields[] = $f;
            }

        }

        if (count($this->table) != 1) {
            $this->fields = $new_fields;
        }

// this->sort_by

        foreach ($this->sort_by as $key => $arr) {
            if (strstr($arr[0], ".")) {
                $temp = explode(".", $arr[0]);
                $t    = $temp[0];
                $f    = $temp[1];
            } else {
                $t = $arr[0];
                $f = "";
            }

            $new_sort_by[] = array(
                $f,
                $arr[1]
            );
        }

        if (count($this->table) != 1) {
            $this->sort_by = $new_sort_by;
        }

// this->affected_column
        foreach ($this->group_by as $key => $val) {
            if (strstr($val, ".")) {
                list($t, $f) = explode(".", $val);
            } else {
                $f = $val;
            }

            $new_group_by[] = $f;
        }

        if (count($this->table) != 1) {
            $this->group_by = $new_group_by;
        }

        $arr_sql[0] = $sql;
        $arr_sql[1] = $parameters;
        $arr_sql[2] = $types;
        return $arr_sql;
    }

    private function edit_is_today_filter($filter)
    {
        $edited_filter = array();
        if (isset($filter["sql"])) {
            $pieces                 = explode("<->", $filter["sql"]);
            $edited_filter["sql"]   = "  DATE(" . $pieces[0] . ") <-> = ?";
            $edited_filter["param"] = date("Y-m-d");
            $edited_filter["type"]  = "s";
        }

        return $edited_filter;
    }

    private function edit_is_current_year($filter)
    {
        $edited_filter = array();
        if (isset($filter["sql"])) {
            $pieces                 = explode("<->", $filter["sql"]);
            $edited_filter["sql"]   = "  YEAR(" . $pieces[0] . ") <-> = ?";
            $edited_filter["param"] = date("Y");
            $edited_filter["type"]  = "i";
        }

        return $edited_filter;
    }

    private function edit_is_current_month($filter)
    {
        $edited_filter = array();
        if (isset($filter["sql"])) {
            $pieces                 = explode("<->", $filter["sql"]);
            $edited_filter["sql"]   = "  MONTH(" . $pieces[0] . ") <-> = ?";
            $edited_filter["param"] = date('m');

            $edited_filter["type"] = "i";
        }

        return $edited_filter;
    }

    private function edit_is_current_user($filter)
    {
        $session_key_to_check = str_replace("session_of_", "", $filter["param"]);

        $edited_filter = array();
        if (isset($filter["sql"])) {
            $pieces                 = explode("<->", $filter["sql"]);
            $edited_filter["sql"]   = $pieces[0] . " <-> = ?";
            $edited_filter["param"] = $_SESSION[$session_key_to_check];
            $edited_filter["type"]  = $filter["type"];
        }

        return $edited_filter;
    }

    private function edit_is_current_quarter($filter)
    {
        $edited_filter = array();
        if (isset($filter["sql"])) {
            $pieces               = explode("<->", $filter["sql"]);
            $edited_filter["sql"] = "  MONTH(" . $pieces[0] . ") <-> = ? ";
            $edited_filter["sql"] .= " || MONTH(" . $pieces[0] . ") <-> = ? ";
            $edited_filter["sql"] .= "||  MONTH(" . $pieces[0] . ") <-> = ? ";
            $edited_filter["param"] = $this->get_correct_quarter(date('m'));

            $edited_filter["type"] = "iii";
        }

        return $edited_filter;
    }

    private function get_correct_quarter($month)
    {

        $yearQuarter = ceil($month / 3);
        switch ($yearQuarter) {
            case 1:
                return array(1, 2, 3);
                break;
            case 2:
                return array("4", "5", "6");
                break;
            case 3:
                return array(7, 8, 9);
                break;
            case 4:
                return array(10, 11, 12);
                break;

            default:
                break;
        }

    }

}
