<?php
/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 *
 */

if (!defined("DIRECTACESS")) {
    exit("No direct script access allowed");
}

class QueryReport extends Report
{
    protected $sql; // the source sql query
    public function set_sql($sql)
    {
        $this->sql = $sql;
    }

    public function __Construct($sql)
    {
        $this->set_sql($sql);
    }

    public function Prepare_Sql()
    {
        global $_URL_PARAMETERS, $tables_parameters;
        $new_sql        = $this->sql;
        $url_parameters = $_URL_PARAMETERS['parameters'];

        $i = 0;

        // Build WHERE clause from filters
        $filter_params = array();

        if (isset($tables_parameters) && is_array($tables_parameters)) {
            $where_conditions = $this->buildWhereConditions($url_parameters, $tables_parameters, $filter_params);
        } else {
            $where_conditions = array();
        }

        if (!empty($where_conditions)) {

// Check if SQL already has WHERE clause
            if (stripos($new_sql, 'WHERE') !== false) {
                $new_sql .= " AND (" . implode(' AND ', $where_conditions) . ")";
            } else {
                $new_sql .= " WHERE (" . implode(' AND ', $where_conditions) . ")";
            }

        }

// if statistical options (removed from query data source

/*
 * if (!empty($groupby_column))
 * $new_sql .= " group by (`".$groupby_column ."`) ";
 *
 */

        if (count($this->sort_by) > 0 || count($this->group_by) > 0) {
            $new_sql .= " order by ";
        }

        $group_by_sort = array();

        foreach ($this->group_by as $g) {
            $flag = 0;
            $i    = 0;

            foreach ($this->sort_by as $arr) {
                if ($g == $arr[0]) {
                    $group_by_sort[] = array(
                        $arr[0],
                        $arr[1]
                    );
                    $flag                 = 1;
                    $this->sort_by[$i][0] = '~xxx~';
                    break;
                }

                $i++;
            }

            if ($flag == 0) {
                $group_by_sort[] = array(
                    $g,
                    '0'
                );
            }

        }

// ************* dump ****************

// foreach($group_by_sort as $arr)

// /{

// /}

// **************************************

        foreach ($this->sort_by as $arr_sort) {
            if ($arr_sort[0] != '~xxx~') {
                $group_by_sort[] = array(
                    $arr_sort[0],
                    $arr_sort[1]
                );
            }

        }

        $i = 0;

        foreach ($group_by_sort as $arr) {

            $new_sql .= "`$arr[0]` ";

            if ($arr[1] == '1') {
                $new_sql .= "desc";
            }

            if ($i < (count($group_by_sort) - 1)) {
                $new_sql .= ",";
            }

            $i++;
        }

        $arr_sql    = array();
        $arr_sql[0] = $new_sql;
        $arr_sql[1] = $filter_params; // Add filter parameters to existing parameters array
        $arr_sql[2] = "";
        return $arr_sql;
    }

    private function buildWhereConditions($url_parameters, $tables_parameters, &$filter_params)
    {
        $conditions = array();

        if (!is_array($tables_parameters)) {
            return $conditions;
        }

// Loop through each parameter definition
        foreach ($tables_parameters as $param_key => $param_config) {

// Validate parameter config structure
            if (!is_array($param_config) ||
                !isset($param_config['column']) ||
                !isset($param_config['if_empty']) ||
                !isset($param_config['default']) ||
                !isset($param_config['key'])) {
                continue;
            }

            $column        = $param_config['column'];
            $if_empty      = $param_config['if_empty'];
            $default_value = $param_config['default'];
            $url_key       = $param_config['key'];

            $filter_value = null;

// Check if the key exists in URL parameters
            if (isset($url_parameters[$url_key])) {
                $filter_value = $url_parameters[$url_key];
            } else {

// Key doesn't exist in URL parameters
                if ($if_empty === 'default') {
                    $filter_value = $default_value;
                } else {
                    // if_empty is 'ignore' or anything else, skip this parameter
                    continue;
                }

            }

// If we have a filter value, add the condition
            if ($filter_value !== null && $filter_value !== '') {
                // Handle dynamic datetime values
                $filter_value = $this->processDynamicValues($filter_value);

// Check if this is a datetime format and create appropriate condition
                if ($this->isDateFormat($filter_value)) {
                    // For datetime, use date range (whole day)
                    $date_start = date('Y-m-d 00:00:00', strtotime($filter_value));
                    $date_end   = date('Y-m-d 23:59:59', strtotime($filter_value));

                    $conditions[]    = "`{$column}` >= ? AND `{$column}` <= ?";
                    $filter_params[] = $date_start;
                    $filter_params[] = $date_end;
                } else {
                    // For non-datetime values, use exact match
                    $conditions[]    = "`{$column}` = ?";
                    $filter_params[] = $filter_value;
                }

            }

        }

        return $conditions;
    }

    private function processDynamicValues($value)
    {

        switch ($value) {
            case 'Current DateTime - Dynamic':
                return date('Y-m-d H:i:s'); // Format: 2025-07-22 14:30:45
            case 'Current Date - Dynamic':
                return date('Y-m-d H:i:s'); // Format: 2025-07-22 14:30:45 (will be converted to date range)
            case 'Current Time - Dynamic':
                return date('H:i:s'); // Format: 14:30:45
            default:
                return $value; // Return original value if no match
        }

    }

    private function isDateTimeFormat($value)
    {

        if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/', $value)) {
            return true;
        }

        return false;
    }

    private function isDateFormat($value)
    {

        if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $value)) {
            return true;
        }

        return false;
    }

}
