<div class="form-group mt-4">
    <div class="row">
        <div class="col-md-6">

            <form>
                <div class="form-group">
                    <label for="userName-search">User Name</label>
                    <input type="text" class="form-control" id="userName-search">
                </div>
                <div class="form-group">
                    <label for="fullname-search">Name</label>
                    <input type="text" class="form-control" id="fullname-search">
                </div>
                <div class="form-group">
                    <label for="email-search">Email</label>
                    <input type="text" class="form-control" id="email-search">
                </div>
            </form>
        </div>
        <div class="col-md-6">

            <form>
                <div class="form-group">
                    <label for="group-search">Group</label>
                    <select class="form-control" id="group-search">
                        <option value="">All</option>
                        @foreach ($groups as $group)
                        <option value="{{ $group->name }}">{{ $group->name }}</option>

                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="status-search">Status</label>
                    <select class="form-control" id="status-search">
                        <option value="">All</option>
                        <option value="active">Active</option>
                        <option value="pended">Pended</option>
                        <option value="blocked">Blocked</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="emailConfirmation-search">Email Confirmation</label>
                    <select class="form-control" id="emailConfirmation-search">
                        <option value="">All</option>
                        <option value="yes">Confirmed</option>
                        <option value="no">Not Confirmed</option>
                    </select>
                </div>
            </form>
        </div>
    </div>

    <div class="form-group text-center">
        <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                class="fas fa-search"></i> Search</button>
        <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
                class="fa-solid fa-eye"></i> Show
            All</button>
    </div>
    </form>

    <div class="mt-2 d-flex justify-content-end">
        <button class="btn btn-primary add-user-button px-3 py-2 float-right srm-button" type="button"
            data-toggle="modal" data-target="#add-user-modal">
            <i class="fas fa-plus"></i> Add New User
        </button>
    </div>

</div>
<div class="clearfix card-body mt-3 table-responsive" width="100%">
    <table id="users" class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>User Name</th>
                <th>Name</th>
                <th>Email</th>
                <th>Group</th>
                <th>Status</th>
                <th>Email Confirmed</th>
                <th>Actions</th>

            </tr>
        </thead>
        <tbody>
            @php $i=0; @endphp
            @foreach($users as $user)
            <tr>
                @if(checkDemo())
                <td>{{ "<User ". ++$i . ">" }}</td>
                <td>{{ "<Name>" }}</td>
                <td>{{ "<Email>" }}</td>
                @else
                <td>{{ $user->user_name }}</td>
                @if(!empty($user->first_name) || !empty($user->last_name))
                <td>{{ $user->first_name . " " . $user->last_name }}</td>
                @else
                <td><span>&nbsp;</span></td>
                @endif
                <td>{{ $user->Email }}</td>

                @endif
                @if(isset($user->group->name))
                
                <td>{{ $user->group->name }}</td>
                @else
                <td><span>&nbsp;</span></td>
                @endif
                <td>
                    @switch($user->status)
                    @case("Active")
                    <span class="badge bg-success">{{ $user->status }}</span>
                    @break
                    @case("Pended")
                    <span class="badge bg-warning">{{ $user->status }}</span>
                    @break

                    @case("Blocked")
                    <span class="badge bg-danger">{{ $user->status }}</span>
                    @break
                    @endswitch
                </td>
                <td>
                    @if($user->isEmailConfirmed())
                    <span class="badge bg-success">Yes</span>
                    @else
                    <span class="badge bg-warning">No</span>

                    @endif
                </td>
                <td>
                    @if(!$user->isAdminAndOwner())
                    <div class="dropdown">
                        <button type="button" id="ellipsisMenu" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false" style="border:none;background:none">

                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                <path
                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                            </svg>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">

                            <a class="dropdown-item edit-user"
                                data-url="{{ route('users.edit',$user->user_ID) }}">Edit</a>
                            @if(strtolower($user->status) == "pended")
                            @if(!$user->isAdminOrOwner())
                            <a class="dropdown-item activate-user" data-toggle="modal"
                                data-target="#activate-user-modal"
                                data-url="{{ route('users.activate',$user->user_ID) }}">Activate</a>
                            @else
                            <form method="POST" id="activate-admin-user-form"
                                data-url="{{ route('users.activate-admin',$user->user_ID) }}">
                                @csrf
                                @method('PATCH')
                            </form>
                            <a class="dropdown-item activate-admin-user">Activate</a>

                            @endif
                            @endif
                            @if(strtolower($user->status) == "blocked")

                            <a class="dropdown-item unblock-user" data-toggle="modal" data-target="#unblock-user-modal"
                                data-url="{{ route('users.unblock',$user->user_ID) }}">unblock</a>
                            @else
                            <a class="dropdown-item block-user" data-toggle="modal" data-target="#block-user-modal"
                                data-url="{{ route('users.block',$user->user_ID) }}">Block</a>
                            @endif
                            <a class="dropdown-item delete-user" data-toggle="modal" data-target="#delete-user-modal"
                                data-url="{{ route('users.destroy',$user->user_ID) }}">Delete</a>
                        </div>
                    </div>
                    @else
                    <span>&nbsp;</span>
                    @endif


                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>
