@extends('layouts.public')

@section('styles')

<style>
    .thick-divider {
        border-width: 3px;
        margin-bottom: 0px;
        padding: 2px;
        border-color: #3D4652;
    }

    .thin-divider {
        border-width: 1px;
        margin-top: 0px;
        padding: 0px;
        border-color: #3D4652;
    }

    .organization-name {
        font-family: 'street_corner';
        font-weight: 100;
        font-size: 14px;
        color: #801818;
    }

    .organization-contact {
        font-family: 'street_corner';
        font-size: 12px;
        font-weight: 100;
        color: #3D4652;
        margin-top: 5px;

    }

    .date-title {
        font-family: 'street_corner';
        font-weight: 100;
        font-style: oblique;
        font-size: 14px;
        color: #3D4652;

    }

    .thick-divider {
        border-width: 3px;
        margin-bottom: 0px;
        padding: 2px;
        border-color: #3D4652;
    }

    .thin-divider {
        border-width: 1px;
        margin-top: 0px;
        margin-bottom: 0px;
        padding: 0px;
        border-color: #3D4652;
    }

    /* grid */
    .report-header-grid {
        display: grid;
        grid-template-columns: 2fr 3fr 1.5fr;
        /* Middle column is wider */
        gap: 10px;
    }

    .right-header {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        grid-column: 2 / 3;
    }

    .report-header-grid .logo {
        grid-column: 1 / 2;
        grid-row: 1 / 2;
        text-align: left;
        align-self: center;
    }

    .report-header-grid .title {
        grid-column: 1 / 2;
        grid-row: 2 / 3;
    }

    .report-header-grid .org-info {
        grid-column: 2 / 3;
        grid-row: 1 / 2;
        text-align: left;
        width: 100%;
    }

    .report-header-grid .qrcode {
        grid-column: 3 / 4;
        grid-row: 1 / 2;
        align-self: center;
        justify-self: center;
    }

    .report-header-grid .date {
        grid-column: 3 / 4;
        grid-row: 2 / 3;
        align-self: center;
        justify-self: center;

    }
</style>

@endsection

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">

            <div class="report-header-grid mt-3 no-print">
                <!-- Logo -->
                <div class="logo">
                    @if(is_null(getSettingsValue('system_logo')))
                    <img src="{{ public_path('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image" />
                    @else
                    <img src="{{ getSystemLogo() }}" alt="Logo" class="brand-image" />
                    @endif
                </div>

                <!-- Organization Info -->
                <div class="right-header">
                    <div class="org-info">
                        <div class="organization-name fw-bold">
                            {{ get_organization() }}
                        </div>
                        @if(!is_null(get_organization_details()))
                        <div class="organization-contact">
                            {!! nl2br(get_organization_details()->contact_info) !!}
                        </div>
                        @endif
                    </div>
                </div>

                <div class="qrcode"></div>
                <!-- Title -->
                <h2 class="title fst-italic mb-0" id="pivot-table-title" style="font-weight: 600">
                    {{ $report->getResourceConfiguration('title') }}
                </h2>

                <!-- Date -->
                <div class="date created-at">
                    Date: {{ \Carbon\Carbon::now()->format('d-m-Y H:i:s') }}
                </div>
            </div>

            <hr class="thick-divider no-print">
            <hr class="thin-divider no-print">
            <div class="mt-4" style="width: 100%">
                <iframe width="100%" style="height:85vh" id="display-blank-report-iframe" src="{{ $url }}{{ request()->has('token') ? '?token='.request()->query('token') : '' }}"
                    frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                    allowfullscreen></iframe>
            </div>

        </div>



@endsection


@section('scripts')

@if(getSettingsValue('enable_qr') == '1')
<script src="{{ get_asset('dist/js/qrcode.min.js')}}"></script>

<script>
    document.querySelectorAll(".qrcode").forEach(element => {
        new QRCode(element, {
            text:"{{ url()->full() }}",
            width:100,
            height:100,
            colorDark : "#000000",
            colorLight : "#ffffff",
            correctLevel : QRCode.CorrectLevel.H

        });

    });

</script>
@endif

@endsection