<div class="modal fade" id="change-category-modal" tabindex="-1" role="dialog" aria-labelledby="modelDataSource"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title mx-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-file-text mx-1"></i>
                    Change category of a Pivot table
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4 my-1">

                <form method="POST" id="change-category-form"
                    data-url="{{ route('pivot-tables.changeCategory',$pivotTable->name) }}">
                    @csrf
                    @method('patch')
                    <div class="form-group">
                        <div class="form-group row justify-content-center">
                            <label for="report-category" class="col-md-2 col-form-label">Category</label>
                            <div class="col-md-4">
                                <select class="form-control" id="report-category" name="pivot_table_category"
                                    placeholder="Select a category">
                                    <option value="">Select a category</option>

                                    @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ $pivotTable->category_id === $category->id ?
                                        "selected" : ""}}>{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                </form>

            </div>

            <div class="container">
                <div class="row justify-content-center text-center">
                    <div class="col-md-4">
                        <button class="btn btn-success mx-2 px-5 py-2" id="saveBtn-change-category">
                            Save
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-light mx-2 px-5 py-2" id="cancelBtn-change-category"
                            data-dismiss="modal">
                            Cancel
                        </button>
                    </div>
                    <div class="col-md-12 mt-3 mb-2">
                        <div id="confirm-change-category" class="alert bootstrap-alert-success mx-4 mb-3"
                            style="display: none" role="alert">

                        </div>
                        <div id="error-change-category" class="alert bootstrap-alert-danger mx-4 mb-3"
                            style="display: none" role="alert">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
