@extends('layouts.app')

@section('styles')

<style>
  div.custom-control-right {
    padding-right: 24px;
    padding-left: 0;
    margin-left: 0;
    margin-right: 0;
  }

  div.custom-control-right .custom-control-label::after {
    right: -1.5rem;
    left: auto;
  }

  div.custom-control-right .custom-control-label::before {
    right: -2.35rem;
    left: auto;
  }
</style>
@endsection


@section('content')

<div class="content-wrapper">
  <div class="content-header mx-3">
    <div class="container-fluid mb-3">
      <div class="row mb-2 mt-3">
        <div class="col-sm-6">
          <h1 class="m-0"><i class="fa-solid fa-code mx-2"></i> Embed Resource</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item active">Embed Resource</li>
          </ol>
        </div>
      </div>
    </div>
    <div class="form-section alert" style="background-color: #DAE8FC">
      <div class="d-flex align-items-center mb-3">
        <i class="fas fa-info-circle text-primary mx-2"></i>
        <strong>About This Page</strong>
      </div>
      <p class="help-text">
        This page allows you to generate an embed code for any report, dashboard, chart, pivot table or KPI. You can
        download an embed file in PHP or HTML, copy a shareable link, or generate a QR code for easy access. Adding the
        downloaded PHP or HTML file to your project will display the embedded resource directly within your application.
      </p>
    </div>


    <div class="card bg-white">
      <div class="card-body">
        <form id="embed-resources-form" class="col-12" data-url="{{ route('embed_resource.generate') }}">
          @csrf
          @method('PUT')

          <div class="form-group">
            <div class="d-flex">
              <label for="resource-type">Resource Type</label>
            </div>
            <div>
              <select name="resource_type" id="resource-type" class="form-control">
                <option value="">Please Select Resource Type</option>
                <option value="dashboard" data-resource-types-url="{{route('dashboards.getAllDashboards')}}"
                  data-access-keys-url="{{route('access_control.getAllAccessKeysByResourceId')}}">Dashboard</option>
                @foreach ($resourceTypes as $type)
                <option value="{{ $type['value'] }}"
                  data-resource-types-url="{{route('resources.getAllEmbedResourcesByModuleId',$type['value'])}}"
                  data-access-keys-url="{{route('access_control.getAllAccessKeysByResourceId')}}">{{ $type['label'] ==
                  'Report List' ? 'Report' : $type['label'] }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="form-group">
            <div class="d-flex">
              <label for="resources">Resource</label>
            </div>
            <div>
              <select name="resources" id="resources" class="form-control">
                <option value="">Please Select Resource</option>
              </select>
            </div>
          </div>

          <div class="form-group">
            <div class="d-flex">
              <label for="access-key">Access Key</label>
            </div>
            <div>
              <select name="access_key" id="access-key" class="form-control">
                <option value="">Please Select Access Key</option>
              </select>
            </div>
          </div>

          <div class="form-group">
            <div class="d-flex">
              <label for="type-of-embed">Type of Embed</label>
            </div>
            <div>
              <select name="type_of_embed" id="type-of-embed" class="form-control">
              </select>
            </div>
          </div>

          <div class="text-center">
            <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Embed" id="saveBtn-embed-resource">

          </div>

          <div id="confirm-embed-resources" class="alert bootstrap-alert-success my-2" role="alert"
            style="display: none">
          </div>

          <div id="share-resource-url-confirm" class="alert bootstrap-alert-success mx-4 mb-3 mt-3" role="alert"
            style="display: none">
            <div style="display: flex; align-items: center; justify-content: center;">
              <div>
                <span id="share-resource-message"></span><br>
                <code id="share-resource-url" style="font-weight:bold;color:black"></code>
              </div>
              <button id="copy-key"
                style="border:none; background:none; cursor:pointer; display:flex; align-items:center; gap:5px;margin-left: 40px;"
                title="Copy">
                <i id="copy-icon" class="fa-solid fa-copy"></i>
                <span id="copy-text">Copy</span>
              </button>
            </div>
          </div>

          <div id="qr-code-confirm" class="mx-4 mb-3 mt-3" role="alert" style="display: none">
            <div id="qr-code" style="display: flex; align-items: center; justify-content: center;">
            </div>
          </div>

          <div id="embed-confirm" class="mx-4 mb-3 mt-3" role="alert" style="display: none;text-align: center">
            <table class="table" style="margin: auto;width:25% !important">
              <tbody>
                <tr style="border-style: hidden">
                  <td class="text-center fw-bold" style="vertical-align: middle;">
                    <div class="d-inline mr-2">
                      @include('dashboard.embed-resource.partials._download_icon')
                    </div>

                    <a target="_blank" href="" class="text-decoration-none" id="embed-url">Download PHP Embed File</a>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <div id="error-embed-resources" class="alert bootstrap-alert-danger my-2" role="alert" style="display: none">
          </div>

        </form>
      </div>
    </div>
  </div>
</div>
@include('dashboard.general.partials._smtp-connections-confirm')

@endsection

@section('scripts')
<script src="{{ get_asset('dist/js/qrcode.min.js')}}"></script>

<script src="{{ get_asset('dist/js/embed-resource.js') }}" defer>
</script>
<script src="{{ get_asset('dist/js/branding.js') }}" defer></script>
@endsection