@extends('layouts.app')

@section('styles')
<!-- DataTables -->
<link rel="stylesheet" href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">

@endsection

@section('content')

@include('dashboard.data-connections.partials.success-modal')


@include('dashboard.data-connections.partials._data-connections-confirmation-modal',[
'id' => 'delete-data-connection',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
])

@include('dashboard.data-connections.partials._data-connections-add-modal')

<div id="edit-dataconnection-modal-container">

</div>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-database mx-2"></i> Data Connections</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Data Connections</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="col-md-6">

                        <form>
                            <div class="form-group">
                                <label for="db-type-search">DB Type</label>
                                <select class="form-control" id="db-type-search">
                                    @if($config = config("srm_config"))
                                    @foreach($config["dashboard"]["dashboard_data_connections"] as $database)
                                    <option value="{{ $database }}">{{ $database }}</option>
                                    @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="connection-name-search">Connection Name</label>
                                <input type="text" class="form-control" id="connection-name-search">
                            </div>

                        </form>
                    </div>
                    <div class="col-md-6">
                        <!-- Second column -->
                        <form>
                            <div class="form-group">
                                <label for="servers-search">Servers</label>
                                <select class="form-control" id="servers-search">
                                    <option value="">All</option>
                                    <option value="localhost">localhost</option>
                                    @foreach ($servers as $server)
                                    <option value="{{ $server }}">{{ $server }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="databases-search">Databases</label>
                                <select class="form-control" id="databases-search">
                                    <option value="">All</option>
                                    @foreach ($databases as $database)
                                    <option value="{{ $database }}">{{ $database }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="form-group text-center ">
                    <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                            class="fas fa-search"></i> Search</button>
                    <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter"
                        type="button"><i class="fa-solid fa-eye"></i> Show All</button>
                </div>
                </form>
                <div class="card-body mt-2 d-flex justify-content-end">

                    <button class="btn btn-primary add-dataconnection-button px-3 py-2 float-right srm-button"
                        type="button" data-toggle="modal" data-target="#add-dataconnection-modal">
                        <i class="fas fa-plus"></i> Add New Data Connection
                    </button>
                </div>


                <div class="card-body">
                    <table id="data-connections" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Connection Name</th>
                                <th>Database Type</th>
                                <th>Server</th>
                                <th>Database</th>
                                <th>Creation Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($default = config('srm_db_config'))
                            <tr>
                                <td>Default</td>
                                <td>{{ $default['driver'] }}</td>
                                @if(checkDemo())
                                <td>{{ '<Server>' }}</td>
                                @else
                                <td>{{ $default['host'] }}</td>
                                @endif
                                <td>{{ $default['database'] }}</td>
                                <td>{{ $default_creation_date }}</td>
                                <td></td>
                            </tr>
                            @endif
                            @foreach($connections as $connection)
                            <tr>
                                <td>{{ $connection->connection_name }}</td>
                                <td>{{ $connection->db_type }}</td>
                                @if(checkDemo())
                                <td>{{ '<Server>' }}</td>
                                @else
                                <td>{{ $connection->server }}</td>
                                @endif
                                <td>{{ $connection->db }}</td>
                                <td>{{ $connection->created_at }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none">
                                            <!-- Your SVG icon -->
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                            </svg>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                            <!-- Your menu items go here -->
                                            <a class="dropdown-item edit-dataconnection"
                                                data-url="{{ route('data_connections.edit',$connection->id) }}">Edit</a>

                                            <a class="dropdown-item delete-data-connection" data-toggle="modal"
                                                data-target="#delete-data-connection-modal"
                                                data-url="{{ route('data_connections.destroy',$connection->id) }}">Delete</a>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

        </div>

</div>


@endsection

@section('scripts')
<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/custom-datatables.js') . '?v='. $srmVersion }}"></script>


<script>
    displayUserPanel();
</script>
<script src="{{ get_asset('dist/js/data-connections.js') }}" defer>
</script>

@if(session('add'))

<script>
    window.onload= function(){
        $('.add-dataconnection-button').click();
    }
</script>

@endif

@endsection
