@extends('layouts.public')

@section('styles')
@php
$defaultPivotTableTheme = getSettingsValue('default_pivot_table_theme','cosmo');
$defaultPivotTableHeight = getSettingsValue('default_pivot_table_height',1000);
$bootstrapCss = "dist/css/themes/$defaultPivotTableTheme/bootstrap.css";
@endphp
<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/metrics.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/bootstrap-icons.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset($bootstrapCss). '?v=' .$srmVersion}}" />

<link rel="stylesheet" href="{{ get_asset('dist/css/pivot-table.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/style.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/nouislider.min.css'). '?v='. $srmVersion }}" />
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }

    .content-wrapper{
        background-color: white !important
    }
    
    .card-tools-custom {
        float: right;
        margin-right: 0.15rem;
        margin-top: 0.5rem;
    }

    .card-tools-right {
        /* float: right; */
        text-align: right
    }


    .icon-custom {
        right: 2rem !important;
        top: 2rem !important;
    }

    .bg-purple {
        background-color: purple !important;
    }


    .c3-tooltip-container {
        background-color: #ffffff;
        border-radius: 0.25em;
        min-width: 180px !important;
        width: auto !important;
        max-width: 300px;
        min-width: 10%;
        padding: 20px;
        box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2);
        pointer-events: auto !important;
    }

    .c3-text {
        transform: translateX(-25px) !important;
        fill: #000 !important;
    }

    .c3 .c3-grid line {
        stroke-opacity: 0.3;
        stroke-width: 1px;
    }

    .c3-xgrid,
    .c3-ygrid {
        stroke-dasharray: 0 0;
    }

    .card-body form * {
        font-size: 0.85rem !important;
    }

    .btn-group-dropdown {

        position: relative;
        display: inline-flex;
        vertical-align: middle;
    }


    .btn-group {
        display: flex;
        align-items: center;
        gap: 10px;
        width: 100%;
    }

    .parameter-label {
        white-space: nowrap;
    }

    .btn-group input[type="date"] {
        flex: 1;
        min-width: 0;
    }

    .table-preview .btn:first-child:active {
        border: none !important;
        border-color: transparent !important;
    }

    .c3-legend {
        max-height: 150px;
        /* adjust as needed */
        overflow-y: auto;
    }
</style>
@if(checkDemo())
<link href="{{ get_asset('dist/css/alertify.core.css')}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/alertify.default.css')}}" rel="stylesheet">
@endif
@endsection


@section('content')
<script src="{{ get_asset('dist/js/moment.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/d3.v5.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/c3.min.js') . '?v='. $srmVersion }}"></script>

<div id="edit-widget-modal-container">

</div>

<div id="add-widget-modal-container">

</div>


@include('dashboard.dashboards.partials._widgets-confirmation-modal',[
'id' => 'delete-widget',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
])

@include('dashboard.dashboards.partials.success-modal')

@include('dashboard.dashboards.partials._add-widget-modal')

<!-- Content Header (Page header) -->
<section class="content-header mx-3">
    <div class="container-fluid">
        <div class="row mb-2 mt-3">
            <div class="col-sm-6">
                <h3> <span style="font-family: 'FontAwesome'"> {!! '&'.
                        $dashboard->icon
                        !!}</span>
                    {{ $dashboard->title }}</h3>
            </div>
        </div>
    </div>
    <!-- /.container-fluid -->
    <div class="container-fluid home-parent-container">
        <div class="clearfix"></div>
        <div class="home-container" style="min-height:70vh">
            <div class="mt-4">

                <div class="loader" style="display: none">
                    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                </div>

                @if(!$paginatedWidgets->isEmpty())

                <div class="row">
                    @foreach ($paginatedWidgets as $widget)
                    @if($widget->resource_id != null)
                    @if(!is_null($widget->resource) && $widget->resource->getResourceType() == "Charts")
                    <div class="{{ $widget->resource->isChartFullSize()  ? 'col-md-12 col-12' : 'col-md-6 col-12'}}">
                        <div class="card card-primary card-outline" style="min-height: 350px">
                            @php
                            $chartID = Str::of($widget->resource->name)->kebab();
                            @endphp
                            <div class="loader" style="display: none">
                                <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                            </div>

                            <div class="card-header">
                                <h3 class="card-title" style="color:black;font-weight:bold">
                                    @if($widget->resource->getResourceConfiguration('chart_link'))
                                    <a href="{{ resourceInternalSignedUrl('charts.details',['chart' => $widget->resource->name], is_null(request()->query('expires')))  }}"
                                        style="color:black">{{
                                        $widget->resource->getResourceConfiguration('title') }}</a>
                                    @else
                                    {{ $widget->resource->getResourceConfiguration('title') }}
                                    @endif

                                </h3>
                            </div>
                            <div class="card-body" @if(in_array($widget->resource->
                                getResourceConfiguration('chart_type'),['pie-chart','donut-chart']))
                                style="max-height: 360px !important;overflow:auto"
                                @endif>
                                @php
                                $chartID = Str::of($widget->resource->name)->kebab();
                                @endphp
                                <div id="{{ $chartID }}"></div>
                                <div id="{{ $chartID }}-error" class="error text-danger text-center"></div>

                                <script>
                                    getChartScript("{!! resourceInternalSignedUrl('charts.build',['chart' => $widget->resource->name], is_null(request()->query('expires'))) !!}", '{{ $chartID }}')
                                </script>
                            </div>
                        </div>

                    </div>
                    @elseif(!is_null($widget->resource) && $widget->resource->getResourceType() == "Pivot tables")
                    <div class="table-preview" style="width: 100%">
                        <div class="col-md-12 col-12">
                            <div class="card card-primary card-outline">
                                <div class="loader" style="display: none">
                                    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                                </div>

                                <div class="card-header">
                                    <h3 class="card-title" style="color:black;font-weight:bold">
                                        <a href="{{ resourceInternalSignedUrl('pivot-tables.show',['pivotTable' => $widget->resource->name], is_null(request()->query('expires')))}}"
                                            style="color:black" class="text-decoration-none">
                                            {{$widget->resource->getResourceConfiguration('pivot_table_title') }}</a>
                                    </h3>
                                </div>
                                <div class="card-body"
                                    style="max-height: {{ $defaultPivotTableHeight }}px;overflow:auto">
                                    @php
                                    $pivotID = Str::of($widget->resource->name)->kebab();
                                    @endphp
                                    <form
                                        data-apply="{{ resourceInternalSignedUrl('pivot-tables.build',['pivotTable' => $widget->resource->name], is_null(request()->query('expires')))}}"
                                        method="POST" class="pivot-table-form" id="{{ $pivotID }}-pivot-table-form">
                                        @csrf
                                        <input type="text" name="pivot_table_name" id="pivot-table-name-textbox"
                                            class="d-none" value="Pivot_Table1">
                                        <input type="hidden" name="alignment" id="alignment"
                                            value="{{ $widget->resource->getResourceConfiguration('alignment') }}">
                                        <div class="row justify-content-center">
                                            <div class="title-container" style="display: none">
                                                <h3>{{
                                                    $widget->resource->getResourceConfiguration('pivot_table_title')
                                                    }}</h3>
                                            </div>
                                            <div class="col-12">
                                                <div class="table-container"
                                                    data-alignment="{{ $widget->resource->getResourceConfiguration('alignment') }}">
                                                    <div>
                                                        @include('dashboard.pivot-tables.partials._preview_minimal')
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    @elseif(!is_null($widget->resource) && $widget->resource->getResourceType() == "KPIs / Metrics")
                    @if($widget->resource->configurations->chart_type == "gauge_chart")
                    <div class="col-md-3 col-12">
                        @php
                        $chartID = Str::of($widget->resource->name)->kebab();
                        @endphp
                        <div class="small-box bg-white">
                            <h6 class="float-left pt-2 pl-2 mb-0" style="font-size:0.8rem">{{
                                $widget->resource->getResourceConfiguration('title')
                                }}</h6>
                            @if(checkMetricAccessPermission($widget->resource))

                            <div class="clearfix"></div>
                            @if(!array_key_exists('error',$widget->resource->data))

                            <div class="inner" style="padding: 0">
                                <div id="{{ Str::of($widget->resource->name)->kebab() }}"></div>
                            </div>
                            <div id="{{ $chartID }}-error" class="error text-danger text-center"></div>

                            <script>
                                {!! $widget->resource->script !!}
                            </script>
                            @else
                            <div class="text-center text-danger pt-4" style="height: 100px">{{
                                $widget->resource->data['error'] }}</div>
                            @endif

                            @if(!array_key_exists('error',$widget->resource->data))
                            @if($widget->resource->getResourceConfiguration('drill_down'))
                            <a href="{{ resourceInternalSignedUrl('metrics.drill',['metric' => $widget->resource->name], is_null(request()->query('expires')))  }}"
                                class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                            @endif
                            @else
                            <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                            </div>

                            @endif
                            @else
                            <div class="flex align-middle">
                                <div id="{{ $chartID }}-error" class="error text-danger text-center pt-5 pb-2">
                                    Access denied for this chart
                                </div>

                            </div>
                            @endif
                        </div>


                    </div>
                    @else

                    <div class="col-md-3 col-12">
                        <div class="small-box {{ $widget->resource->getMetricBgColor() }}">
                            @if(checkMetricAccessPermission($widget->resource))
                            <div class="inner">
                                @if(!array_key_exists('error',$widget->resource->data))

                                @if($widget->resource->getResourceConfiguration('compare_with') != "no_comparison")
                                <span data-toggle="custom-tooltip" data-html="true" data-placement="bottom"
                                    title="{{ $widget->resource->data['tooltip'] }}"
                                    style="margin-left: 1rem;font-size:small">
                                    @if(!in_array($widget->resource->getResourceConfiguration('display_format'),['percentage','percentage_of_total']))
                                    {{ $widget->resource->data['change'] }}
                                    @endif
                                    (
                                    @if(!is_numeric($widget->resource->data['trend']))
                                    {{$widget->resource->data['trend'] }}%
                                    @elseif($widget->resource->data['trend_direction'] == "positive")
                                    ↑{{$widget->resource->data['trend'] }}%
                                    @elseif($widget->resource->data['trend_direction'] == "negative")
                                    ↓{{$widget->resource->data['trend'] }}%
                                    @endif
                                    )</span><br>
                                <span @if($widget->resource->getResourceConfiguration('compare_with') ==
                                    "no_comparison")
                                    class="mt-4" @endif data-toggle="custom-tooltip" data-html="true"
                                    data-placement="bottom" style="font-size:2rem;font-weight:bold"
                                    title="{{ $widget->resource->data['tooltip'] }}">{{
                                    $widget->resource->data['original_metric'] }}</span>
                                <p>{{ $widget->resource->getResourceConfiguration('title') }}</p>
                                @else
                                <h3 @if($widget->resource->getResourceConfiguration('compare_with') ==
                                    "no_comparison")
                                    class="mt-4" @endif>{{ $widget->resource->data['original_metric'] }}</h3>
                                <p>{{ $widget->resource->getResourceConfiguration('title') }}</p>
                                @endif
                                @else
                                <p>{{ $widget->resource->getResourceConfiguration('title') }}</p>
                                <div class="text-center text-danger" style="height: 75px" data-toggle="tooltip"
                                    data-placement="top" data-title="{{$widget->resource->data['error']}}">{{
                                    \Illuminate\Support\Str::limit($widget->resource->data['error'], 80)}}</div>

                                @endif

                            </div>
                            @if($widget->resource->configurations->chart_type == "info_box_with_icon")
                            <div class="icon">
                                <i class="icon-custom fas" style="font-family: 'FontAwesome'">{!!
                                    $widget->resource->getResourceIcon() !!}</i>
                            </div>
                            @endif
                            @if(!array_key_exists('error',$widget->resource->data))
                            @if($widget->resource->getResourceConfiguration('drill_down'))
                            <a href="{{ resourceInternalSignedUrl('metrics.drill',['metric' => $widget->resource->name], is_null(request()->query('expires')))  }}"
                                class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                            @endif
                            @else
                            <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                            </div>

                            @endif
                            @else
                            <p class="pt-2 pl-2">{{ $widget->resource->getResourceConfiguration('title') }}</p>
                            <div class="pt-5 text-center pb-2">Access denied for this metric</div>
                            @endif

                        </div>

                    </div>
                    @endif
                    @endif

                    @else
                    @if(!is_null($widget->report_lists))

                    <div class="col-md-3 col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{ $widget->title }}</h3>
                            </div>

                            <div class="card-body p-0" style="display: block;">
                                <ul class="nav nav-pills flex-column">
                                    @foreach ($widget->report_lists as $report)
                                    <li class="nav-item">
                                        <a class="nav-link"
                                            href="{{ getReportUrl($report['url']) }}?mode=embed{{ request()->has('token') ? '&token='.request()->query('token') : '' }}">{{
                                            $report['name'] }}</a>
                                    </li>

                                    @endforeach
                                </ul>
                            </div>

                        </div>
                        @endif
                    </div>
                    @endif
                    @endforeach
                </div>
                @else
                <div class="text-center">
                    {{ __('dashboards.messages.no_widgets') }}
                </div>
                @endif

            </div>

        </div>
        @if($paginatedWidgets->lastPage() > 1)
        <div class="float-right">
            {{ $paginatedWidgets->appends(request()->query())->links() }}
        </div>
        <div class="clearfix"></div>
        @endif

</section>
@endsection


@section('scripts')
<script type="text/javascript" src="{{ get_asset('dist/js/bootstrap.bundle.min.js') . '?v='. $srmVersion }}"></script>

@if(checkDemo())
<script src="{{ get_asset('dist/js/alertify.min.js') . '?v='. $srmVersion }}"></script>
@endif

<script src="{{ get_asset('dist/js/widgets.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/pivot-tables/pivot-functions.js') . '?v='. $srmVersion }}"></script>
<script src=" {{ get_asset('dist/js/nouislider.min.js') . '?v='. $srmVersion }}"></script>

<script src="{{ get_asset('dist/js/pivot-tables/show_in_home.js') . '?v='. $srmVersion }}"></script>

@endsection