<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Smart Report Maker</title>

    <link rel="stylesheet" href="{{ public_path('dist/css/all.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/adminlte.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/style.css'). '?v='. $srmVersion}}" />
    {{-- <style>
        .content-wrapper>* {
            font-family: 'poppins', 'arial';
        }
    </style> --}}

<body>

    <div class="content-wrapper" style="background-color:white !important">
        <section class="content-header">
            <div class="row">
                <div class="col-sm-7 float-left">
                    <h3 style="font-weight: bold;line-height: 1.8">{{ucwords($chart->getResourceConfiguration('name'))
                        }}</h3>
                    <h6>{{ \Carbon\Carbon::now()->format('d M Y h:i A') }}
                    </h6>
                </div>
                <div class="col-sm-4 text-right float-right">
                    <div class="branding-logo">
                        @if(is_null(getSettingsValue('system_logo')))
                        <img src="{{ public_path('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image" />
                        @else
                        <img src="{{ getSystemLogo(true) }}" alt="Logo" class="brand-image w-100" />
                        @endif
                    </div>

                </div>
                <div style="clear:both"></div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
            <div>
                <table class="table table-bordered" style="word-wrap: break-all;">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <th>{{ ucwords($chart->getResourceConfiguration('x_axis_column')) }}</th>
                            <th>{{ !empty($chart->getResourceConfiguration('label')) ?
                                ucwords($chart->getResourceConfiguration('label')) :
                                ucwords($chart->getResourceConfiguration('y_axis_column'))}}</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach(array_combine($chart->data['x_axis'],$chart->data['y_axis']) as $x_axis
                        =>$y_axis)
                        <tr class="smaller-font">
                            <td>
                                @if($chart->getResourceConfiguration('date_time_scale') == "months")
                                {{Illuminate\Support\Carbon::parse($x_axis)->format('Y-m') }}
                                @elseif($chart->getResourceConfiguration('date_time_scale') == "years")
                                {{Illuminate\Support\Carbon::parse($x_axis)->format('Y') }}
                                @else
                                {{ $x_axis }}
                                @endif

                            </td>
                            <td>{{ $y_axis }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="pt-5">
                    <img src="{{ $image }}" alt="Chart Image" class="p-0 m-0 w-100" style="width:100%">
                </div>

            </div>

    </div>
</body>
