@extends('layouts.public')
@php
$srmVersion = getSrmVersion();
@endphp
@section('styles')
<!-- DataTables -->
<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css'). '?v='. $srmVersion }}" />
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }

    .c3-tooltip-container {
        background-color: #ffffff;
        border-radius: 0.25em;
        min-width: 180px !important;
        width: auto !important;
        max-width: 300px;
        min-width: 10%;
        padding: 20px;
        box-shadow: 0 0 1px rgba(0, 0, 0, .125),
            0 1px 3px rgba(0, 0, 0, .2);
        pointer-events: auto !important;
    }

    .c3-text {
        transform: translateX(-25px) !important;
        fill: #000 !important;
    }

    .c3 .c3-grid line {
        stroke-opacity: 0.3;
        stroke-width: 1px;
    }

    .c3-xgrid,
    .c3-ygrid {
        stroke-dasharray: 0 0;
    }
</style>

@endsection

@section('content')



<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('charts.index') }}">Charts</a></li>
                        <li class="breadcrumb-item">{{ $chart->name }}</li>
                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h2 style="font-weight: bold">{{ ucwords($chart->getResourceConfiguration('name')) }}</h2>
                    <h6>{{ \Carbon\Carbon::now()->format('d M Y h:i A') }}</h6>
                </div>
                <div class="col-sm-4 text-right">
                    <div class="p-2 branding-logo">
                        @include('partials._logo')
                    </div>

                </div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
        </div>
        <div class="container-fluid mt-4 px-4">
            <div class="buttons text-right mb-4">

                <form id="chartExportForm" action="{{ route('charts.details.autoexport',$chart->name) }}" method="POST"
                    style="display: none;">
                    @csrf
                    <input type="hidden" id="chartImageData" name="chartImageData">
                </form>

                <form id="chartPrintForm" action="{{ route('charts.details.print',$chart->name) }}" method="POST"
                    style="display: none;">
                    @csrf
                    <input type="hidden" id="chartPrintImageData" name="chartPrintImageData">
                </form>


            </div>
            <div>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <th>{{ ucwords($chart->getResourceConfiguration('x_axis_column')) }}</th>
                            <th>{{ !empty($chart->getResourceConfiguration('label')) ?
                                ucwords($chart->getResourceConfiguration('label')) :
                                ucwords($chart->getResourceConfiguration('y_axis_column'))}}</th>
                            @if($chart->getResourceConfiguration('drill_down'))
                            <th></th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(array_combine($chart->data['x_axis'],$chart->data['y_axis']) as $x_axis =>$y_axis)
                        <tr class="smaller-font">
                            <td>
                                @if($chart->getResourceConfiguration('date_time_scale') == "months")
                                {{Illuminate\Support\Carbon::parse($x_axis)->format('Y-m') }}
                                @elseif($chart->getResourceConfiguration('date_time_scale') == "years")
                                {{Illuminate\Support\Carbon::parse($x_axis)->format('Y') }}
                                @else
                                {{ $x_axis }}
                                @endif
                            </td>
                            <td>{{ $y_axis }}</td>

                            @if($chart->getResourceConfiguration('drill_down'))
                            <th><a href="{{route('charts.drill',[$chart->name,$x_axis])}}" class="text-primary" style="color:black;
                                text-decoration: underline;
                                font-weight:normal
                                ">Details</a> </th>
                            @endif
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>

            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title" style="color:black;font-weight:bold">
                        @if($chart->getResourceConfiguration('chart_link'))
                        <a href="{{ route('charts.details',$chart->name) }}" style="color:black">{{
                            $chart->name }}</a>
                        @else
                        {{ $chart->name }}
                        @endif
                    </h3>
                </div>
                <div class="card-body">
                    <div id="{{ Str::of($chart->name)->kebab() }}"></div>
                    <canvas id="chartCanvas" style="display: none;"></canvas>

                </div>

            </div>

        </div>

</div>


@endsection


@section('scripts')
<script src="{{ get_asset('dist/js/moment.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/d3.v5.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/c3.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/charts.js') . '?v='. $srmVersion }}"></script>
<script>
    {!! $chart->script !!}
d3.selectAll(".c3")
    .selectAll("text")
    .style("font-family", "poppins, arial");


</script>
@php
$chartID = Str::of($chart->name)->kebab();
$chartName = Str::of($chart->name)->camel();
@endphp
<script src="{{ get_asset('dist/js/html2canvas.min.js') }}"></script>

<script>
    $(document).ready(function() {

    function exportChartImage(element,form) {

    var chart = document.getElementById("{{ $chartID }}");

    html2canvas(chart, {
        backgroundColor: null,
        scale: 1.5,
        logging: false
    }).then(function(canvas) {
        var chartImage = canvas.toDataURL('image/png');

        document.getElementById(element).value = chartImage;

        $.ajax({
            type: 'POST',
            url: $("#" + form).attr('action'),
            data: $("#" + form).serialize(),
            xhrFields:{
                responseType: 'blob'
            },
            success: function(response) {
                // var blob = new Blob([response]);
                // var link = document.createElement('a');
                // link.href = URL.createObjectURL(blob);
                // link.download = "{{ ucwords($chart->getResourceConfiguration('name')) }}.pdf";
                // link.click();
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });


    });

    }

    exportChartImage('chartImageData','chartExportForm');

    });
</script>

@endsection
