<div class="modal fade" id="view-access-key-modal" tabindex="-1" aria-labelledby="displayAccessKeyModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content p-3">
            <div class="modal-header p-1">
                <h5 class="modal-title" id="displayAccessKeyModalLabel">Display Access Key</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row mb-2">
                    <div class="col-6 fw-bold">Label</div>
                    <div class="col-6" style="overflow-wrap: anywhere;">{{ $accessKey->label }}</div>
                </div>

                <div class="row mb-2">
                    <div class="col-6 fw-bold">Type</div>
                    <div class="col-6">{{ $accessKey->type }}</div>
                </div>

                <div class="row mb-2">
                    <div class="col-6 fw-bold">Group</div>
                    <div class="col-6">{{ isset($accessKey->group) ? $accessKey->group->name : '' }}</div>
                </div>

                <div class="row mb-2">
                    <div class="col-6 fw-bold">Embedding Origin Restriction</div>
                    <div class="col-6">
                        {{ $accessKey->origin_type }}
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-6 fw-bold">Allowed Origins</div>
                    <div class="col-6">
                        @foreach(explode(" ", $accessKey->allowed_origins) as $origin)
                            {{ $origin }}<br>
                        @endforeach
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-6 fw-bold">Uses Count</div>
                    <div class="col-6">{{ $accessKey->uses_count }}</div>
                </div>

                <div class="row mb-2 align-items-center">
                    <div class="col-6 fw-bold">Show Access Key</div>
                    <div class="col-6">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="showAccessKey">
                            <label class="custom-control-label" for="showAccessKey"></label>
                        </div>
                    </div>
                </div>

                <div id="accessKeyContainer" style="display:none;" class="mt-2">
                    <code id="accessKey">{{ decrypt($accessKey->access_key) }}</code>
                </div>
            </div>
        </div>
    </div>
</div>
