$(document).ready(function () {

    // delete scheduled report modal
    $('#scheduled-reports').on('click', ".delete-scheduled-report", function (event) {
        let report = $(this).closest('tr').find('td:first').text();
        $('#delete-scheduled-report-modal').find('.modal-body p').text(`Are you sure you want to delete "${report}" scheduled report task?`)
        $('#delete-scheduled-report-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#delete-scheduled-report-form").on("click", "#saveBtn-delete-scheduled-report", function () {

        sendAjaxRequestWithSuccess("delete-scheduled-report-form", 'delete-scheduled-report-modal', reloadScheduledReportsTable, ["scheduled-reports"]);

    });


    // stop scheduled report modal
    $('#scheduled-reports').on('click', ".stop-scheduled-report", function (event) {
        let report = $(this).closest('tr').find('td:first').text();
        $('#stop-scheduled-report-modal').find('.modal-body p').text(`Are you sure you want to stop "${report}" scheduled report task?`)
        $('#stop-scheduled-report-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#stop-scheduled-report-form").on("click", "#saveBtn-stop-scheduled-report", function () {

        sendAjaxRequestWithSuccess("stop-scheduled-report-form", 'stop-scheduled-report-modal', reloadScheduledReportsTable, ["scheduled-reports"]);

    });

    // resume scheduled report modal
    $('#scheduled-reports').on('click', ".resume-scheduled-report", function (event) {
        let report = $(this).closest('tr').find('td:first').text();
        $('#resume-scheduled-report-modal').find('.modal-body p').text(`Are you sure you want to resume "${report}" scheduled report task?`)
        $('#resume-scheduled-report-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#resume-scheduled-report-form").on("click", "#saveBtn-resume-scheduled-report", function () {

        sendAjaxRequestWithSuccess("resume-scheduled-report-form", 'resume-scheduled-report-modal', reloadScheduledReportsTable, ["scheduled-reports"]);

    });


    // stop scheduled report modal
    $('#scheduled-reports').on('click', ".manual-send", function (event) {
        event.preventDefault();
        let url = $(this).data("url");
        $.ajax({
            type: "POST",
            url: url,
            contentType: false,
            processData: false,
            dataType: "json",
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function (response) {
                if (response.message) {

                    $(`#success-modal`).find('h5').text(response.message).show();
                    $(`#success-modal`).modal('show');
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }


            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

            }
        });

    });

});
