// reports table
var collapsedGroups = {};

let reportsTable = $('#reports').DataTable({
    "dom": "lrtip",
    "paging": true,
    "orderFixed": [2, 'asc'],
    "order": [[4, 'desc']],
    "pageLength": 100,
    "lengthChange": false,
    "searching": true,
    "ordering": true,
    "order": [],
    "columnDefs": [{
        "targets": 6,
        "orderable": false
    },
    {
        "targets": 1,
        "visible": false,
    },
    {
        "targets": 2,
        "visible": false,
    }
    ],
    "info": true,
    "autoWidth": false,
    "responsive": true,
    "language": {
        "zeroRecords": "No records matches your search criteria",
        "emptyTable": "No reports to preview"
    },
    rowGroup: {
        dataSrc: 1,
        startRender: function (rows, group) {

            if (collapsedGroups[group] === undefined) {
                collapsedGroups[group] = false; // default to expanded
            }

            var collapsed = collapsedGroups[group];

            rows.nodes().each(function (r) {
                r.style.display = collapsed ? 'none' : '';
            });

            if (group.includes('</i>')) {
                trimmedGroup = group.substring(group.indexOf('</i>') + 4).trim();
            }
            return $('<tr/>')
                .addClass('group-start')
                .append(
                    `<td colspan="6">
                    <span class="group-toggle-box">
                        <div class="toggle-box">${collapsed ? '+' : '-'}</div>
                    </span>
                    ${group}
                </td>`
                )
                .toggleClass('collapsed', collapsed)
                .attr('data-name', trimmedGroup)
                .attr('data-icon', group);

        }
    },
    drawCallback: function (settings) {
        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
        pagination.toggle(this.api().page.info().pages > 1);
    }

});



$('#reports tbody').on('click', 'tr.group-start', function () {
    var tr = $(this);
    var name = tr.attr('data-icon');
    var isCollapsed = collapsedGroups[name];

    collapsedGroups[name] = !isCollapsed;

    // Update the toggle box text directly
    tr.find('.toggle-box').text(isCollapsed ? '-' : '+');

    var rows = reportsTable.rows({ search: 'applied' }).nodes();
    $(rows).each(function () {
        var rowGroup = reportsTable.cell(this, 1).data();
        if (rowGroup === name) {
            $(this).css('display', isCollapsed ? '' : 'none');
        }
    });
});

window.applyReportsSearch(reportsTable);
window.clearReportsSearch(reportsTable);
