$(document).ready(function () {


    $(document).on('click', ".delete-pivot-table", function (event) {
        let pivotTable = $(this).closest('tr').find('td:first').text();
        $('#delete-pivot-table-modal').find('.modal-body p').text(`Are you sure you want to delete "${pivotTable}" pivot table?`)
        $('#delete-pivot-table-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#delete-pivot-table-form").on("click", "#saveBtn-delete-pivot-table", function () {

        sendAjaxRequestWithSuccess("delete-pivot-table-form", 'delete-pivot-table-modal', reloadPivotTable, ["pivot-tables"]);

    });

    $(document).on('click', ".display-pivot-table", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                window.location.href = url;
            }, error: function (response) {

                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

                $("#global-loader").fadeOut();

            }

        });

    });



    $(document).on('click', ".edit-pivot-table", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                window.location.href = url;
            }, error: function (response) {

                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

                $("#global-loader").fadeOut();

            }

        });

    });




    $(document).on('click', ".change-category", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $("#global-loader").fadeIn();
            },

            success: function (response) {
                $("#global-loader").fadeOut();

                $('#change-category-modal-container').html(response);
                $('#change-category-modal').modal('show');

                $("#change-category-modal").on("click", "#saveBtn-change-category", function () {

                    let fields = ["report_category"];
                    sendAjaxRequest("change-category-form", fields, "confirm-change-category", "error-change-category", reloadPivotTable, ["pivot-tables"]);
                });

                $("#change-category-modal").on("click", "#cancelBtn-change-category", function () {
                    reloadForm("change-category-form");
                    $('#error-change-category, #confirm-change-category').hide();

                });


            },
        });

    });


    $(document).on('click', ".duplicate-pivot-table", function () {
        let url = $(this).data('url');
        $('#duplicate-modal').modal('show');
        $('#duplicate-form').attr('data-url', $(this).attr('data-url'))
        $('#duplicate-form #name').val($(this).attr('data-name') + "_1")
    });


    $(document).on("click", "#saveBtn-duplicate", function () {
        
        sendAjaxRequestWithErrorsAndWithSuccess("duplicate-form", 'duplicate-modal','error-duplicate', reloadPivotTable, ["pivot-tables"]);

    });






});
