function preventWrongDataTypeDrop(closestList, datatype) {


    let fieldSections = ["row-headers", "column-headings", "values-fields"];
    let parameters = ["parameters"];

    let validations = {
        "row-headers": `The Row Headers Field can't be a ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "row-headers-time": `Row headers cannot be a DateTime field. Please add it to the column headers instead.`,
        "column-headings": `The Column Headings Field can't be a  ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "values-fields": `The Values section Field can't be a ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "parameters": `A field of ${datatype.toUpperCase()} data type cannot be used as a parameter.`
    }

    const dateTypes = ["DATE", "DATETIME", "TIMESTAMP", "TIME"];
    const textDataType = ["TEXT", "VARCHAR","ENUM"];
    const specialDataTypes = ["BLOB", "LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "GEOMETRY", "POINT", "LINESTRING", "POLYGON"];
    const jsonDataType = ["JSON"];

    if(textDataType.includes(datatype.toUpperCase()) && closestList == "values-fields"){

        $(`#pivot-info-modal`).find('h5').html(`
            <div  style="text-align: justify;text-justify: inter-word;">To get a better experience with the pivot table, try dragging a numerical column into the "Values" section. It will appear in the main body of the table, where a mathematical function (such as sum or average) will be applied. For example, you can use columns like "Paid" from the test_SalesOrder table , "unitPrice" from the test_Product table or "salary" from test_Employee table.</div>
            <br>
            <div style="text-align: justify;text-justify: inter-word;"> Please note that in the full version, you can drag and drop any column from your database, regardless of its data type.</div>`);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;

    }


    if (closestList == "row-headers" && dateTypes.includes(datatype.toUpperCase())) {

        $(`#pivot-info-modal`).find('h5').text(validations["row-headers-time"]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    if (fieldSections.includes(closestList)
        &&
    (
        specialDataTypes.includes(datatype.toUpperCase())
        || jsonDataType.includes(datatype.toUpperCase())
    )
    ) {

        $(`#pivot-info-modal`).find('h5').text(validations[closestList]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    if (parameters.includes(closestList) && specialDataTypes.includes(datatype.toUpperCase())) {

        $(`#pivot-info-modal`).find('h5').text(validations[closestList]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    return false;

}