$(document).ready(function () {

    
    $(document).on('change', "#group", function (event) {
        if (window.parent) {
            if ($(this).val() == "add-new-group")
                window.parent.location.href = $('option:selected', this).data("url");
        }

    });

    $(document).on("click", "#copy-key", function (e) {
        e.preventDefault();

        let keyElement = document.getElementById("access-key-value");

        if (!keyElement || !keyElement.textContent.trim()) {
            alert("No key to copy!");
            return;
        }

        let range = document.createRange();
        range.selectNodeContents(keyElement);

        let selection = window.getSelection();
        selection.removeAllRanges();
        selection.addRange(range);

        // Change icon & text
        $("#copy-icon").removeClass("fa-copy").addClass("fa-check");
        $("#copy-text").text("Copied");

        try {
            document.execCommand("copy");
            selection.removeAllRanges();

            setTimeout(function () {
                $("#copy-icon").removeClass("fa-check").addClass("fa-copy");
                $("#copy-text").text("Copy");
            }, 2000);

        } catch (err) {
            console.error("Copy failed", err);
            alert("Unable to copy. Please copy manually.");
        }


    });



    $(document).on("change", "#origin", function () {
        if ($(this).val() == "same-origin" || $(this).val() == "any-origin") {
            $("#allowed-origins").prop("disabled", true);
        } else {
            $("#allowed-origins").prop("disabled", false);
        }
    });


    $(document).on("change", "#type", function () {
        if ($(this).val() == "limited") {
            $("#group").prop("disabled", false);
        } else {
            $("#group").prop("disabled", true);
        }
    });


    $(".container").on("click", ".add-access-key-button", function () {
        reloadForm("add-access-key-form");
    });

    $("#delete-access-key-form").on("click", "#saveBtn-delete-access-key", function () {

        sendAjaxRequestWithSuccess("delete-access-key-form", 'delete-access-key-modal', reloadAccessKeyTable, ["access-keys"]);

    });


    // delete access key modal
    $('#access-keys').on('click', ".delete-access-key", function (event) {
        let access_key = $(this).closest('tr').find('td:first').text().trim();

        $('#delete-access-key-modal').find('.modal-body p').html(`Are you sure you want to delete this access key "${access_key}" ?<br>This may break any integration using this key. `)
        $('#delete-access-key-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#revoke-access-key-form").on("click", "#saveBtn-revoke-access-key", function () {

        sendAjaxRequestWithSuccess("revoke-access-key-form", 'revoke-access-key-modal', reloadAccessKeyTable, ["access-keys"]);

    });

    // delete category confirmation
    $('.revoke-access-key').on('click', function (event) {
        $('#revoke-access-key-form').attr('action', $(this).attr('data-url'))
    });

    $('#access-keys').on('click', ".revoke-access-key", function (event) {
        let access_key = $(this).closest('tr').find('td:first').text().trim();

        $('#revoke-access-key-modal').find('.modal-body p').html(`Are you sure you want to revoke all tokens linked to this key?`)
        $('#revoke-access-key-form').attr('data-url', $(this).attr('data-url'))
    });

    // delete category confirmation
    $('.delete-access-key').on('click', function (event) {
        $('#delete-access-key-form').attr('action', $(this).attr('data-url'))
    });




    // add access key
    $("#add-access-key-form").on("click", "#saveBtn-add-access-key", function () {

        let fields = ["label", "type", "group", "allowed_ips"];
        sendAjaxRequestAccessKeys("add-access-key-form", fields, "add-access-key-confirm", "add-access-key-error", reloadAccessKeyTable, ["access-keys"]);

        $('#add-access-key-modal').on('hidden.bs.modal', function () {
            reloadForm("add-access-key-form");
        });

    });

    $("#add-access-key-form").on("click", "#cancelBtn-add-access-key", function () {
        reloadForm("add-access-key-form");
    });


    $(document).on('click', ".view-access-key", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#view-access-key-modal-container').html(response);
                $('#view-access-key-modal').modal('show');

                $('[data-toggle="tooltip"]').tooltip();

                document.getElementById('showAccessKey').addEventListener('change', function () {
                    document.getElementById('accessKeyContainer').style.display = this.checked ? 'block' : 'none';
                });

                document.getElementById('copyAccessKey').addEventListener('click', function () {
                    const accessKey = document.getElementById('accessKey').innerText;
                    navigator.clipboard.writeText(accessKey).then(() => {
                        const icon = document.getElementById('copyAccessKey');
                        icon.classList.remove('fa-copy');
                        icon.classList.add('fa-check');
                        setTimeout(() => {
                            icon.classList.remove('fa-check');
                            icon.classList.add('fa-copy');
                        }, 2000);
                    });
                });

            },
        });

    });


});
