<?php

namespace App\Services;

use App\Models\Group;

class TourGuideService
{

    public function getLastTourGuidePage()
    {

        if (
            is_null($this->lastStep())
            || $this->lastStep() > 28
            // || ($this->lastStep() == 27 && !auth()->user()->isAdminOrOwner())
        ) {
            return route('home');
        }

        if ($this->lastStep() >= 1 && $this->lastStep() <= 3) {
            return route('home', ["step" => $this->lastStep()]);
        }

        if ($this->lastStep() > 3 && $this->lastStep() <= 11) {
            return route('profile.index', ["step" => $this->lastStep()]);
        }

        if ($this->lastStep() > 11 && $this->lastStep() <= 19) {
            return route('general.index', ["step" => $this->lastStep()]);
        }

        if ($this->lastStep() > 19 && $this->lastStep() <= 28) {

            if (auth()->user()->isAdminOrOwner() && !is_null(Group::first())) {
                return route('home', ["step" => $this->lastStep()]);
            } elseif (auth()->user()->isAdminOrOwner()) {
                return route('users.index', ["step" => $this->lastStep()]);
            } else {
                return route('profile.index', ["step" => $this->lastStep()]);

            }

        }

    }

    private function lastStep()
    {
        return auth()->user()->guided_tour_last_visited_step;
    }

}
