<?php

namespace App\Services;

use App\Models\Setting;

class GeneralSettingsService
{
    public function getSettings()
    {
        $settings = Setting::get();

        $arrayOfSettings = $settings->map(function ($key) {
            return  [$key->settings_key => $key->settings_value];
        });

        return array_merge(...$arrayOfSettings);
    }

    public function update($settings)
    {
        foreach ($this->prepareToUpdate($settings) as $setting => $value) {
            Setting::updateOrCreate(
                [
                    'settings_key' => $setting
                ],
                [
                    'settings_value' => $value
                ]
            );
        }
    }

    private function prepareToUpdate($data)
    {
        return [
            'user_registeration_is_enabled' => isset($data["allow_register"]) ? 1 : 0,
            'fromName' => $data["from_name"],
            'fromEmail' => $data["from_email"],
            'timezone' => $data["timezone"],
            'mail_signature' => $data["mail_signature"],
            'default_pivot_table_theme' => isset($data["default_pivot_table_theme"]) ? $data["default_pivot_table_theme"] : 'cosmo',
            'default_pivot_table_height' => isset($data["default_pivot_table_height"]) ? $data["default_pivot_table_height"] : 1000,
            'enable_qr' => isset($data["enable_qr"]) ? 1 : 0,
            'google_api_key' => isset($data["google_api_key"]) ? $data["google_api_key"] : '',
            'google_map_width' => isset($data["google_map_width"]) ? $data["google_map_width"] : '',
            'google_map_height' => isset($data["google_map_height"]) ? $data["google_map_height"] : '',
        ];
    }
}
