<?php

namespace App\Services;

use App\Models\BarcodeDefinition;


class BarcodeService
{
    public function index()
    {
        return BarcodeDefinition::all();
    }


    public function store($request)
    {
        return BarcodeDefinition::create($request);
    }

    public function update($data, $barcode)
    {
        $barcode->update($data);
    }

    public function destroy($barcode)
    {
        $this->checkHasBarCode($barcode);

        $barcode->delete();
    }


    private function checkHasBarCode($barcode)
    {   
        if ($barcode->barcode_usage()->exists()) {
            abort(400, trans('barcodes.remove_barcode_usage_before',
                ['barcode' => $barcode->label]));
        }

    }
}
