<?php

namespace App\Repositories;

use App\Models\User;


class UserRepository
{

    public function createUser($data)
    {
        $data = $this->prepareData($data);

        return User::create($data);
    }


    public function updateUser($user, $data)
    {
        $data = $this->prepareData($data);

        return $user->update($data);
    }


    private function prepareData($data)
    {
        if (isset($data['email_confirm']) && $data['email_confirm'] === "yes")
            $data['email_verified_at'] = date('Y-m-d H:i:s');
        else if (isset($data['email_confirm']) && $data['email_confirm'] === "no")
            $data['email_verified_at'] = null;


        $data += [
            'status' => ucfirst($data['status']),
        ];

        if ($data['role'] == 'admin') {

            $data += [
                'is_admin' => 1,
                'group_id' => null
            ];
        } else if ($data['role'] == 'user') {

            $data += [
                'group_id' => $data['group'],
                'is_admin' => 0

            ];
        }

        return $data;
    }
}
