<?php

namespace App\Repositories;

use App\Models\DataConnection;
use App\Models\User;


class DataConnectionRepository
{

    public function store($data, $connection_string)
    {

        switch (strtolower($data["database_type"])) {
            case 'mysql':
                $this->storeMySQLDataConnection($data, $connection_string);
                break;
            case 'postgresql':
                break;
        }
    }

    private function storeMySQLDataConnection($data, $connection_string)
    {
        DataConnection::create([
            'connection_name' => $data["connection_name"],
            'db_type' => 'MySQL',
            'server' => $data["server"],
            'db' => $data["database"],
            'connection_string' => $connection_string,
        ]);
    }


    public function update($data, $connection_string, $connection)
    {
        switch (strtolower($data["database_type"])) {
            case 'mysql':
                $this->updateMySQLDataConnection($data, $connection_string, $connection);
                break;
            case 'postgresql':
                break;
        }
    }

    private function updateMySQLDataConnection($data, $connection_string, $connection)
    {
        $connection->update([
            'connection_name' => $data["connection_name"],
            'db_type' => 'MySQL',
            'server' => $data["server"],
            'db' => $data["database"],
            'connection_string' => $connection_string,
        ]);
    }
}
