<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SMTPMails extends Model
{
    use HasFactory;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';
    public $timestamps = false;

    protected $fillable = [
        'smtp',
        'port',
        'username',
        'Password',
        'encryption',
        'auth_mode',
        'is_default',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}mail";
    }

    public function scopeDefaultSMTPMail($query)
    {
        return $query->where('is_default', 1);
    }
}
