<?php

namespace App\Models;

use App\Models\ModulePermission;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Group extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $primaryKey = 'group_ID';
    protected $connection = 'mysql';


    protected $fillable = [
        'name',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}Group";
    }


    public static function tableName()
    {
        return with(new static())->getTable();
    }

    public function users()
    {
        return $this->hasMany(User::class, 'group_id', 'group_ID');
    }

    public function module_permissions()
    {
        return $this->hasMany(ModulePermission::class, 'group_id');
    }

    public function resource_permissions()
    {
        return $this->hasMany(ResourcePermission::class, 'group_id');
    }

    public function hasResourcePermission($resource_id)
    {
        return $this->resource_permissions()->where('resource_id', $resource_id)->exists();
    }

    public function hasModulePermission($module_id)
    {
        return $this->module_permissions()->where('module_id', $module_id)->exists();
    }
}