<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmbedToken extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'access_key_id',
        'token',
        'allowed_resource_url',
        'expire_at'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}embed_tokens";
    }

    public function accessKey()
    {
        return $this->belongsTo(AccessKey::class, 'access_key_id');
    }

    public function hasValidAccessKey()
    {
        $accessKey = $this->accessKey;
        if (!$accessKey) {
            return false;
        }

        if ($accessKey->allowed_ips) {
            $allowedIps = explode(',', $accessKey->allowed_ips);
            if (!in_array(getClientIpv4(request()), $allowedIps)) {
                return false;
            }

        }

        return true;
    }

}
