<?php

namespace App\Models;

use App\Models\Group;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmbedPreference extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'key',
        'value'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}embedding_preferences";
    }

    public static function tableName()
    {
        return with(new static())->getTable();
    }



}
