<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BarcodeUsage extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'barcode_definition_id',
        'resource_id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}barcode_definitions";
    }

    public static function tableName()
    {
        return with(new static )->getTable();
    }

    public function resources()
    {
        return $this->belongsTo(Resource::class, 'resource_id');
    }

    public function barcode_definitions()
    {
        return $this->belongsTo(BarcodeDefinition::class, 'barcode_definition_id');
    }
}
