<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use App\Models\Resource;
use Illuminate\Validation\ValidationException;

class ReportTestMail implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function send()
    {
        $this->buildMailMessage("Report Test");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
            public_path('index.php')
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $report = Resource::find(76);

        $this->content = view(
            'dashboard.mails.test',
            compact('report')
        )->render();
    }
}
