<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ChangePasswordConfirmMail implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function send()
    {
        $this->buildMailMessage("Smart Report Maker Password Change Confirmation");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        // $username = $this->username;
        // $organization = get_organization();
        $signature = $this->signature;


        $this->content = view(
            'auth.mails.password-changed',
            compact('signature')
        )->render();
    }
}
