<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;

class CheckEmbededTokenRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            'Authorization' => ['required'],
            'resource_url' => ['required', 'max:255'],
        ];
    }

    public function messages()
    {
        return [
            'Authorization.required' => trans('api.validations.required.messages.token'),
            'resource_url.required'           => trans('api.validations.required.resource_url'),
        ];
    }

    protected function prepareForValidation()
    {   
        $this->merge([
            'Authorization' => $this->header('Authorization'),
        ]);
    }

    protected function failedValidation(Validator $validator)
    {
        $response = response()->json([
            'message' => $validator->errors()->first(),
        ], 400);

        throw new ValidationException($validator, $response);
    }
}
