<?php
namespace App\Http\Middleware;

use App\Exceptions\ExpiredSignatureException;
use Closure;
use App\Exceptions\InvalidSignatureException;
use Illuminate\Routing\Middleware\ValidateSignature as MiddlewareValidateSignature;

class ValidateSignature extends MiddlewareValidateSignature
{
    protected $except = [
        'xValue',
        'export',
        'page'
    ];

    public function handle($request, Closure $next, ...$args)
    {
        if(auth()->user()){
            return $next($request);
        }

        [$relative, $ignore] = $this->parseArguments($args);
        if ($request->hasValidSignatureWhileIgnoring(array_merge($this->except, $ignore), !$relative)) {
            return $next($request);
        }

        if ($request->has('expires') && $this->signatureHasExpired($request)) {
            throw new ExpiredSignatureException;
        }

        throw new InvalidSignatureException;
    }

    protected function parseArguments(array $args)
    {
        $relative = ! empty($args) && $args[0] === 'relative';

        if ($relative) {
            array_shift($args);
        }

        $ignore = array_merge(
            property_exists($this, 'except') ? $this->except : $this->ignore,
            $args
        );
        return [$relative, $ignore];
    }

    protected function signatureHasExpired($request)
    {
        $expires = $request->query('expires');

        return $expires && now()->getTimestamp() > $expires;
    }
}
