<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class TourGuideMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if (checkDemo()) {
            $this->runDemoTourGuide();
        }

        return $next($request);

    }

    private function runDemoTourGuide()
    {

        if (!Session::has('tour_guide_shown')) {

            Session::put('tour_guide_shown', true);

        } else {

            Session::put('tour_guide_shown', false);

        }

    }

}