<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\TourGuideService;

class TourGuideController extends Controller
{

    private $tourGuideService;

    public function __construct(TourGuideService $tourGuideService)
    {
        $this->tourGuideService = $tourGuideService;
    }

    public function start()
    {
        auth()->user()->is_checked_guided_tour = true;
        auth()->user()->save();
    }

    public function step(Request $request)
    {
        auth()->user()->guided_tour_last_visited_step = $request->step;
        auth()->user()->save();
    }

    public function rewatch(Request $request)
    {

        if ($request->start == "begin") {

            auth()->user()->is_checked_guided_tour = false;
            auth()->user()->save();

            return response()->json([
                'url' => route('home')
            ]);

        } elseif ($request->start == "last") {
            auth()->user()->is_checked_guided_tour = false;
            auth()->user()->save();

            return response()->json([
                'url' => $this->tourGuideService->getLastTourGuidePage()
            ]);

        }

    }

}
