<?php

namespace App\Http\Controllers;

use App\Http\Middleware\OnlyFullVersion;
use App\Models\Organization;
use Illuminate\Http\Request;
use App\Services\ProfileService;
use Illuminate\Support\Facades\Hash;
use App\Mails\ChangePasswordConfirmMail;
use App\Http\Requests\changePasswordRequest;
use App\Http\Requests\UpdateContactDetailsRequset;
use App\Http\Requests\storeOrganizationLogoRequest;
use App\Http\Requests\UpdateOrganizationDetailsRequest;

class ProfileController extends Controller
{
    private $profileService;

    public function __construct(ProfileService $profileService)
    {
        $this->profileService = $profileService;
        $this->middleware(OnlyFullVersion::class)->only(
            [
                'updateContactDetails',
                'changePassword',
                'updateOrganizationDetails',
                'storeOrganizationLogo',
                'removeOrganizationLogo',
            ]
        );
    }
    public function index()
    {
        $security_questions = getSecurityQuestions();
        $organization_details = Organization::first();

        return view("dashboard.profile.index", compact('security_questions', 'organization_details'));
    }


    public function updateContactDetails(UpdateContactDetailsRequset $request)
    {
        auth()->user()->update($request->validated());

        return response()->json([
            'message' => trans('profile.updated')
        ]);
    }

    public function changePassword(changePasswordRequest $request)
    {
        return $this->profileService->changePassword(
            $request->validated()['currentpassword'],
            $request->validated()['password'],
            auth()->user()->Password
        );
    }

    public function updateOrganizationDetails(UpdateOrganizationDetailsRequest $request)
    {
        $this->profileService->updateOrganizationDetails($request->validated());
        return response()->json([
            'message' => trans('profile.organization_saved')
        ]);
    }

    public function storeOrganizationLogo(storeOrganizationLogoRequest $request)
    {
        $this->profileService->storeOrganizationLogo($request->file('logo'));

        return response()->json([
            'message' => trans('profile.logo_saved')
        ]);
    }

    public function removeOrganizationLogo()
    {
        $this->profileService->removeOrganizationLogo();
    }
}
