<?php

namespace App\Http\Controllers\PivotTables;

use App\Services\PivotTableService;
use App\Http\Controllers\Controller;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\PivotTable\PivotTableRequest;

class PivotTableStoreController extends Controller
{
    private $pivotTableService;

    public function __construct(PivotTableService $pivotTableService)
    {
        $this->pivotTableService = $pivotTableService;

        $this->middleware(OnlyFullVersion::class);

    }

    public function __invoke(PivotTableRequest $request)
    {
        $resourceId = $this->pivotTableService->store($request->validated());

        return response()->json([
            'success' => true,
            "message" => trans('pivot-tables.messages.store'),
            "resource" => $resourceId
        ]);

    }

}
