<?php

namespace App\Http\Controllers\Metrics\Wizard;

use App\Models\Resource;
use App\Services\MetricService;
use App\Http\Controllers\Controller;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\Metrics\DataStepRequest;
use App\Http\Requests\Metrics\DataStepUpdateRequest;

class DataStepController extends Controller
{
    public $metricService;
    public function __construct(MetricService $metricService)
    {
        $this->metricService = $metricService;

        $this->middleware(OnlyFullVersion::class)->only([
            'store',
            'update'
        ]);

    }

    public function store(DataStepRequest $request)
    {
        $this->metricService->storeDataStep($request);

        return response()->json([
            'success',
            'last_page' => $this->metricService->getMetricLastPage($request)

        ]);
    }

    public function update(DataStepUpdateRequest $request, Resource $metric)
    {
        $this->metricService->updateDataStep($request, $metric);

        return response()->json([
            'success'
        ]);
    }
}