<?php

namespace App\Http\Controllers;

use App\Services\HomeService;
use App\Services\AccessKeyService;
use App\Services\EmbedResourceService;
use App\Services\EmbedPreferencService;
use App\Http\Middleware\OnlyFullVersion;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\generateEmbedResourceRequest;

class EmbedPluginController extends Controller
{
    public $homeService;
    public $accessKeyService;

    public function __construct(HomeService $homeService, AccessKeyService $accessKeyService)
    {
        $this->homeService           = $homeService;
        $this->accessKeyService = $accessKeyService;
        
        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update'
            ]
        );
    }

    public function index()
    {
        $resourceTypes = $this->homeService->getResourceTypes();

        $accessKeys = $this->accessKeyService->index();

        return view('dashboard.embed-plugin.index', compact('resourceTypes','accessKeys'));
    }


}
