<?php

namespace App\Http\Controllers;

use App\Models\Dashboard;
use App\Services\HomeService;
use App\Models\DashboardWidget;
use App\Http\Middleware\OnlyFullVersion;
use App\Services\DashboardWidgetService;
use App\Http\Requests\StoreDashboardWidgetRequest;
use App\Http\Requests\UpdateDashboardWidgetRequest;

class DashboardWidgetController extends Controller
{
    private $homeService;
    private $dashboardWidgetService;
    public function __construct(DashboardWidgetService $dashboardWidgetService, HomeService $homeService)
    {
        $this->homeService            = $homeService;
        $this->dashboardWidgetService = $dashboardWidgetService;

        $this->middleware(OnlyFullVersion::class)->only([
            'store',
            'update',
            'destroy'
        ]);

    }

    public function create(Dashboard $dashboard)
    {
        $resourceTypes = $this->homeService->getResourceTypes();

        if (checkDemo()) {
            $widget       = $this->dashboardWidgetService->getRecentWidget($dashboard);
            $resourceType = $this->homeService->getResourceType($widget);

            $resources = !is_null($widget->resource)
            ? $this->homeService->getAllResources($widget->resource->module->id)
            : $this->homeService->getAllResources(null);
            return view('dashboard.dashboards.partials._add-widget-modal-demo', compact('widget', 'resourceTypes', 'resources', 'resourceType'));
        }

        return view('dashboard.dashboards.partials._add-widget-modal', compact('resourceTypes', 'dashboard'));

    }

    public function store(StoreDashboardWidgetRequest $request, Dashboard $dashboard)
    {
        $this->dashboardWidgetService->store($request, $dashboard);

        return response()->json([
            'success'   => true,
            'message'   => trans('dashboard_widgets.messages.store_widget'),
            'last_page' => $this->dashboardWidgetService->getDashboardLastPage($request, $dashboard)

        ]);

    }

    public function edit(Dashboard $dashboard, DashboardWidget $widget)
    {
        $resourceTypes = $this->homeService->getResourceTypes();
        $resourceType  = $this->homeService->getResourceType($widget);

        $resources = !is_null($widget->resource)
        ? $this->homeService->getAllResources($widget->resource->module)
        : $this->homeService->getAllResources(null);

        return view('dashboard.dashboards.partials._edit-widget-modal', compact('dashboard', 'widget', 'resourceTypes', 'resources', 'resourceType'));

    }

    public function update(UpdateDashboardWidgetRequest $request, Dashboard $dashboard, DashboardWidget $widget)
    {
        $this->dashboardWidgetService->update($request, $dashboard, $widget);

        return response()->json([
            'success' => true,
            'message' => trans('dashboard_widgets.messages.save_widget')
        ]);

    }

    public function destroy(Dashboard $dashboard, DashboardWidget $widget)
    {
        $this->dashboardWidgetService->destroy($dashboard, $widget);

        return response()->json([
            'message'   => trans('dashboard_widgets.messages.delete'),
            'last_page' => $this->dashboardWidgetService->getDashboardLastPage(request(), $dashboard)

        ]);

    }

}