<?php

namespace App\Http\Controllers\Charts;

use App\Models\Resource;
use Illuminate\Http\Request;
use App\Services\ChartService;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

class ChartDetailsPrintController extends Controller
{
    public $chartService;

    public function __construct(ChartService $chartService)
    {
        $this->chartService = $chartService;
    }

    public function __invoke(Resource $chart)
    {

        $chart = $this->chartService->detailsExport($chart);
        $image = request()->input('chartPrintImageData');

        $pdf = Pdf::loadView('dashboard.charts.pdf.details', compact('chart', 'image'));

        return $pdf->stream($chart->name . '.pdf');
    }
}
