<?php

namespace App\Http\Controllers\Charts;

use App\Models\Resource;
use Illuminate\Http\Request;
use App\Services\ChartService;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Spatie\Browsershot\Browsershot;

class ChartDetailsAutoExportController extends Controller
{
    public $chartService;

    public function __construct(ChartService $chartService)
    {
        $this->chartService = $chartService;

    }

    public function __invoke(Resource $chart)
    {
        $chart = $this->chartService->detailsExport($chart);
        // $image = base64_decode(request()->input('chartImageData'));
        $base64_str = base64_decode(substr(request()->input('chartImageData'), strpos(request()->input('chartImageData'), ",") + 1));
        $image = public_path().'/image.png';
        file_put_contents(public_path().'/image.png', $base64_str);
        $pdf = Pdf::loadView('dashboard.charts.pdf.details', compact('chart', 'image'));

        $pdf->save('srm_storage/'.$chart->name.'.pdf');
    }
}
