<?php

namespace App\Generators;

class ParametersGenerator
{
    private $parameters;
    private $parametersValues;
    private $combineFiltersBy;

    public function __construct($parameters, $parametersValues, $combineFiltersBy)
    {
        $this->parameters       = $parameters;
        $this->parametersValues = $parametersValues;
        $this->combineFiltersBy = $combineFiltersBy;
    }

    public function build()
    {
        $sql              = '';
        $bindings         = [];
        $parameters       = destructParametersBlocks($this->parameters);
        $values = $this->parametersValues;

        if (is_null($this->parameters) || empty($this->parameters)) {
            return null;
        }

        foreach ($parameters as $index => $param) {
            $currentParamValues = isset($values[$param['label']]) ? $values[$param['label']] : [];
            if ((is_array($currentParamValues) && in_array(null, $currentParamValues, true))) {
                continue;
            }

            $sqlAndBindings = (new ParametersFilter($param, $currentParamValues))
                ->getSqlAndBindings();

            if (empty($sqlAndBindings[0])) {
                continue;
            }

            $sql .= $sqlAndBindings[0] . " {$this->combineFiltersBy} ";

            $bindings = array_merge($bindings, $sqlAndBindings[1]);
        }

        $sql = rtrim($sql, " {$this->combineFiltersBy} ");

        if ($sql == "") {
            return null;
        }

        return [
            "sql"      => $sql,
            "bindings" => $bindings
        ];
    }

}
