<?php

namespace App\Generators;

class DataFiltersGenerator
{
    private $filters;
    private $combineFiltersBy;

    public function __construct($filters, $combineFiltersBy)
    {
        $this->filters = $filters;
        $this->combineFiltersBy = $combineFiltersBy;
    }


    public function build()
    {
        $filters = destructFilters($this->filters);
        $sql = '';
        $bindings = [];

        if (is_null($filters)) {
            return null;
        }

        foreach ($filters as $key => $filter) {
            $sqlAndBindings = (new DataFilter($filter, strtolower($filter['type'])))->getSqlAndBindings();
            $sql .= $sqlAndBindings[0] . " {$this->combineFiltersBy} ";
            $bindings = array_merge($bindings, $sqlAndBindings[1]);
        }

        $sql = rtrim($sql, " {$this->combineFiltersBy} ");

        return [
            "sql" => $sql,
            "bindings" => $bindings
            ];
    }
}
