# 🔌 SRM Integration Plugin – Embed MySQL Reports, Dashboards, and Charts into Your WordPress Site

## 📊 Overview

**SRM Embed** is a powerful WordPress plugin that allows you to seamlessly embed **Smart Report Maker (SRM)** resources into your WordPress website. Whether you're working with **reports**, **dashboards**, **pivot tables**, **charts**, or **KPIs**, this plugin makes integration smooth and secure.

Easily embed analytics generated from your **MySQL database** using SRM, including:

- MySQL **Reports**
- Interactive **Charts**
- Real-time **Dashboards**
- Flexible **Pivot Tables**
- Custom **KPIs** and **Metrics**

With **secure token management**, support for both public and private resources, and **no coding required**, SRM Embed lets you deliver powerful data visualizations directly within your website or web application.

---

## ✅ Prerequisites

Before using this plugin, ensure you have the following:

- An active installation of **Smart Report Maker (SRM)**
- A **MySQL** database connected to SRM
- One or more analytics resources (reports, charts, dashboards, or pivot tables) created in SRM

You can get Smart Report Maker here:  
👉 [https://mysqlreports.com/mysql-reporting-tools/the-best-mysql-report-builder/](https://mysqlreports.com/mysql-reporting-tools/the-best-mysql-report-builder/)

---

## 📘 What Is Smart Report Maker?

[Smart Report Maker (SRM)](https://mysqlreports.com/mysql-reporting-tools/the-best-mysql-report-builder/) is an advanced PHP-based reporting and dashboard tool for MySQL databases. It allows you to create:

- **Dynamic Dashboards** for real-time data monitoring
- **MySQL Pivot Tables** with drag-and-drop functionality
- **Advanced PHP Charts** for visualizing complex data
- **Scheduled Reports** via email
- **KPI Monitoring** with customizable metrics
- **Comprehensive Data Analysis** tools

SRM transforms raw MySQL data into actionable insights without requiring any coding skills—making it ideal for business users, analysts, and developers alike.

---

## ✨ Features

- Embed **MySQL-based Reports**, **Charts**, **Dashboards**, **Pivot Tables**, and **KPIs**
- Supports both **public** and **private** SRM resources
- Secure **token-based access control** for private resources
- Integrates easily into **WordPress Pages**, **Posts**, and **Custom Post Types**
- Supports both **limited access** and **full access** keys from SRM

### 🔒 Encryption

- **Access Keys**: Encrypted automatically using WordPress salts
- **Runtime Decryption**: Decryption occurs only during API calls
- **No Plaintext Storage**: Sensitive data is never stored in plain text

---

## 🧩 Installation

1. Download and install the **SRM Embed** plugin.
2. Activate the plugin via **WordPress Dashboard → Plugins**.
3. Ensure you have **Smart Report Maker (SRM)** set up and connected to your **MySQL database**.
4. In SRM, navigate to **Embed Manager → SRM WP Plugin** to retrieve your embedding information.

---

## ⚙️ Configuration & Use

### 🔗 Step 1: Prepare Your Resources in SRM

- Log in to **Smart Report Maker**
- Navigate to the **Embed Manager**
- Open the **"SRM WP Plugin"** section
- Copy the required resource details (Report, Chart, Dashboard, Pivot Table, or KPI)

---

### 🧾 Step 2: Add the Shortcodes to WordPress

After retrieving the embed information from SRM, use it to generate a **shortcode**. You can insert this shortcode into:

- **WordPress Pages**
- **WordPress Posts**
- **Custom Post Types**

Use the **Shortcode Block** in the Block Editor (Gutenberg), or paste it directly into the Classic Editor.

---

## 🔐 🚨 IMPORTANT SECURITY NOTE (FOR PRIVATE RESOURCES)

> ⚠️ **PLEASE READ CAREFULLY**

If you're embedding **private reports, charts, KPIs, or dashboards**, you **must place them inside protected areas of your website**.

### ✅ What This Means

- The WordPress **page or post** that contains the shortcode **must be restricted to logged-in users**
- Visitors must **log in using their WordPress credentials** before accessing private resources
- This ensures that only **authorized users** can access sensitive content

> 🛑 **Do NOT embed private shortcodes on public pages. This may expose confidential data.**

Use a login system or a membership plugin to protect any content that displays private analytics.

---

## ℹ️ Best Practices for Shortcodes

- Shortcodes can be used on **any WordPress page, post, or custom post type**
- For **private resources**, ensure that shortcodes are added only to **protected pages**
- You can use plugins like:
  - **Members**
  - **Restrict Content**
  - **WP-Members**

These help you control access by user roles or membership levels.

---

## 🧠 Tips for New Users

- Not sure what you're embedding? SRM clearly labels each resource in the **Embed Manager**
- Use **Limited Access Keys** to restrict access to specific users or groups
- Test shortcodes on a **private draft page** before publishing
- Double-check that your **resource URL** and **access key** are correct

---

## ✅ You're All Set!

You're now ready to embed powerful **MySQL analytics** into your WordPress site using SRM Embed.  
Display dynamic reports, charts, dashboards, and more — securely and effortlessly.

For more help, visit the official SRM documentation or contact their support team.

---

## 🛠 Troubleshooting

### Common Issues and Fixes

#### ❌ Shortcode Creation Errors

1. **"The provided SRM resource URL is not valid."**
   - Go to SRM → Embed Manager → *SRM WP Plugin*
   - Ensure you copy the correct resource URL with `mode=embed` included

2. **"Missing resource URL"**
   - In the "Create Shortcode" card, provide a valid resource URL from SRM

3. **"Missing access key for private resource"**
   - Go to **General Settings** and set the `srm_access_key`
   - Get your key from SRM’s **Embed Manager**

4. **"Unrecognized access rule"**
   - In the "Create Shortcode" card, set `access_rule` to either `public` or `private`

#### ⚙️ Configuration Errors

5. **"SRM configuration is incomplete"**
   - Set both the **Embed Token API URL** and **Access Key** in the plugin’s **General Settings**
   - Get both values from SRM → Embed Manager → *SRM WP Plugin*

6. **"Failed to decrypt access key"**
   - Re-enter your access key in **General Settings**
   - Ensure `libsodium` or `OpenSSL` is installed
   - Save the settings again to re-encrypt the key

#### 🔧 System Requirements

7. **"Required PHP extension(s) are not available"**
   - Install and enable:
     - `cURL`: `extension=curl`
     - `JSON`: `extension=json`
   - Restart your web server (Apache, Nginx, PHP-FPM)

8. **"Encryption libraries missing"**
   - Preferred: `libsodium`
     - Enable with `extension=sodium`
   - Alternative: `OpenSSL`
     - Enable with `extension=openssl`
   - Restart your server after making changes

#### 🔐 Token & Authentication Errors

9. **"Embed Token Error"**
   - Check that:
     - Your **access key** is correct
     - The **API endpoint** is reachable
     - The **resource URL** is accurate
     - Your SRM installation is up and running

---

### 📋 System Requirements

- **PHP**: 7.4 or later
- **WordPress**: 5.0 or later
- **PHP Extensions**:
  - `cURL`
  - `JSON`
- **Encryption**:
  - `libsodium` (preferred)
  - `OpenSSL` (fallback)

---

## 🆘 Support

If you need help:

- Check for configuration warnings in the plugin's admin settings
- Verify your SRM embed settings and access key
- Ensure all required PHP extensions are enabled

For SRM-specific issues:

- Visit the official SRM site:  
  [https://mysqlreports.com/mysql-reporting-tools/the-best-mysql-report-builder/](https://mysqlreports.com/mysql-reporting-tools/the-best-mysql-report-builder/)
- Browse the full documentation
- Submit a support request if needed

---

## 📝 Changelog

### Version 1.7.0
- Added validation for `mode=embed` in resource URLs
- Introduced "KPIs / Metrics" as a new resource type
- Improved error messages for invalid embed URLs
- Enhanced embed usage guidance

### Version 1.6
- Renamed shortcodes admin page to "Create New Shortcode"
- Updated "Manage" section title to "Existing Shortcodes"
- Increased width of admin cards for usability

### Version 1.4.0
- Updated all references from "shortcuts" to "shortcodes"
- Improved consistency and clarity in admin UI

### Version 1.3.0
- Refined error messages
- Strengthened URL validation

### Version 1.1.0
- Added URL validation to shortcode creation
- Enabled copy-to-clipboard for shortcodes
- Expanded help text and guidance
- Improved shortcode ordering (newest first)

### Version 1.0.0
- Initial release
- Secure token encryption and access control
- Admin UI for managing settings and shortcodes
- Full support for public and private resources

---

## 📄 License

This plugin is licensed under the **MIT License**.
